/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.join;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.join.ConfigJoinMapper;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;

public class AttrNode {
    public Class<?> target;
    protected boolean isCollection;
    public AttrNode parent;
    public List<AttrNode> children;
    public PropertyDescriptor typePdInParent;
    public Map<Integer, String> colMap = new HashMap<Integer, String>();
    Map<String, AttributeConvert> attrConvertMap = new HashMap<String, AttributeConvert>();
    public Map<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();

    public AttrNode() {
        this.parent = null;
    }

    public AttrNode(AttrNode parent) {
        this.parent = parent;
    }

    public void initNode(Class<?> target, Map<String, Object> jsonMapping, Map<String, Integer> columnIndexMap) {
        this.target = target;
        ClassAnnotation an = ClassAnnotation.getClassAnnotation(target);
        if (an.isContainExtAnnotation()) {
            this.attrConvertMap = an.getExtAnnotation().getAttributeConvertMap();
        }
        for (Map.Entry<String, Object> entry : jsonMapping.entrySet()) {
            String attr = entry.getKey();
            Object value = entry.getValue();
            PropertyDescriptor pd = BeanKit.getPropertyDescriptor(target, (String)attr);
            if (pd == null) {
                throw new BeetlSQLException(3, "\u5b57\u6bb5[" + attr + "]\u6620\u5c04\u89c4\u5219\u9519\u8bef\uff0c\u5b9e\u4f53\u7c7b\u65e0\u8be5\u6bb5");
            }
            if (value instanceof String) {
                String col = (String)value;
                Integer index = columnIndexMap.get(col);
                if (index == null) continue;
                this.colMap.put(index, attr);
                this.propertyMap.put(attr, pd);
                continue;
            }
            if (this.children == null) {
                this.children = new ArrayList<AttrNode>();
            }
            Map childMapping = (Map)value;
            Class<?> type = pd.getPropertyType();
            AttrNode childNode = new AttrNode(this);
            childNode.typePdInParent = pd;
            if (Collection.class.isAssignableFrom(type)) {
                this.isCollection = true;
                Type genericReturnType = pd.getReadMethod().getGenericReturnType();
                Class<Map> childTarget = BeanKit.getCollectionType((Type)genericReturnType);
                if (childTarget == null) {
                    childTarget = Map.class;
                }
                childNode.initNode(childTarget, childMapping, columnIndexMap);
                this.children.add(childNode);
                continue;
            }
            childNode.initNode(type, childMapping, columnIndexMap);
            this.children.add(childNode);
        }
    }

    public void visit(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ReadTypeParameter rtp) throws Exception {
        ConfigJoinMapper.NodeValue nodeValue = this.getNodeValueFromResultSet(renderContext, ctx, rtp);
        if (!nodeValue.isValid) {
            return;
        }
        ConfigJoinMapper.Grid grid = renderContext.grid;
        if (grid.contain(this, nodeValue.key)) {
            ConfigJoinMapper.ObjectWrapper realObj = grid.getNodeValue((AttrNode)this, (Object)nodeValue.key).objectWrapper;
            if (this.parent != null) {
                ConfigJoinMapper.ObjectWrapper parentObj = renderContext.parent;
                this.assignToParent(renderContext, ctx, parentObj, realObj, this.typePdInParent);
            }
            renderContext.parent = realObj;
            this.visitAll(renderContext, ctx, rtp);
            return;
        }
        grid.push(this, nodeValue);
        this.fillObject(nodeValue);
        ConfigJoinMapper.ObjectWrapper realObj = nodeValue.objectWrapper;
        if (this.parent != null) {
            ConfigJoinMapper.ObjectWrapper parentObj = renderContext.parent;
            this.assignToParent(renderContext, ctx, parentObj, realObj, this.typePdInParent);
        }
        renderContext.parent = realObj;
        this.visitAll(renderContext, ctx, rtp);
    }

    void fillObject(ConfigJoinMapper.NodeValue nodeValue) throws Exception {
        ConfigJoinMapper.ObjectWrapper objectWrapper = new ConfigJoinMapper.ObjectWrapper();
        objectWrapper.fromNodeValue = nodeValue;
        objectWrapper.target = this.target;
        objectWrapper.makeObject(this.propertyMap);
    }

    ConfigJoinMapper.NodeValue getNodeValueFromResultSet(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ReadTypeParameter rtp) throws SQLException {
        if (this.colMap.isEmpty()) {
            return new ConfigJoinMapper.NodeValue(false);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanProcessor beanProcessor = renderContext.beanProcessor;
        boolean allNull = true;
        for (Map.Entry<Integer, String> entry : this.colMap.entrySet()) {
            Object value;
            String attr = entry.getValue();
            AttributeConvert attributeConvert = this.attrConvertMap.get(attr);
            if (attributeConvert != null) {
                Object value2 = attributeConvert.toAttr(ctx, this.target, attr, rtp.rs, rtp.index);
                map.put(attr, value2);
                continue;
            }
            rtp.setIndex(entry.getKey());
            PropertyDescriptor ps = this.propertyMap.get(entry.getValue());
            Class<?> propertyType = ps.getPropertyType();
            JavaSqlTypeHandler sqlTypeHandler = beanProcessor.getHandler(propertyType);
            if (sqlTypeHandler == null) {
                sqlTypeHandler = beanProcessor.getDefaultHandler();
            }
            if ((value = sqlTypeHandler.getValue(rtp)) != null) {
                allNull = false;
            }
            map.put(attr, value);
        }
        if (allNull) {
            return new ConfigJoinMapper.NodeValue(false);
        }
        ConfigJoinMapper.NodeValue nodeValue = new ConfigJoinMapper.NodeValue(map);
        return nodeValue;
    }

    void assignToParent(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ConfigJoinMapper.ObjectWrapper parent, ConfigJoinMapper.ObjectWrapper attrValue, PropertyDescriptor typePdInParent) throws Exception {
        Class<?> propertyType = typePdInParent.getPropertyType();
        if (List.class.isAssignableFrom(propertyType) || Set.class.isAssignableFrom(propertyType)) {
            HashSet<Object> set = parent.flagMap.get(typePdInParent);
            if (set == null) {
                set = new HashSet<Object>();
                parent.flagMap.put(typePdInParent, set);
            }
            if (set.contains(attrValue.fromNodeValue.key)) {
                return;
            }
            Collection values = (Collection)typePdInParent.getReadMethod().invoke(parent.realObject, new Object[0]);
            if (values == null) {
                values = BeanKit.newCollectionInstance(typePdInParent.getPropertyType());
                typePdInParent.getWriteMethod().invoke(parent.realObject, values);
            }
            values.add(attrValue.realObject);
            set.add(attrValue.fromNodeValue.key);
        } else if (!parent.flagMap.containsKey(typePdInParent)) {
            BeanProcessor beanProcessor = ctx.sqlManager.getDefaultBeanProcessors();
            beanProcessor.callSetter(parent.realObject, typePdInParent, attrValue.realObject, typePdInParent.getPropertyType());
        }
    }

    public void visitAll(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ReadTypeParameter rtp) throws Exception {
        if (this.children != null) {
            ConfigJoinMapper.ObjectWrapper wrapper = renderContext.parent;
            for (AttrNode node : this.children) {
                node.visit(renderContext, ctx, rtp);
                renderContext.parent = wrapper;
            }
        }
    }
}

