/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;

public interface ConnectionSource {
    public static final ThreadLocal<DataSource> forceDs = new ThreadLocal<DataSource>(){

        @Override
        protected DataSource initialValue() {
            return null;
        }
    };

    public Connection getMasterConn();

    public Connection getMetaData();

    public Connection getConn(ExecuteContext var1, boolean var2);

    public boolean isTransaction();

    default public void applyStatementSetting(ExecuteContext ctx, Connection conn, Statement statement) throws SQLException {
    }

    default public void applyConnectionSetting(ExecuteContext ctx, Connection conn) {
    }

    default public void closeConnection(Connection conn, ExecuteContext ctx, boolean isUpdate) {
        if (!this.isTransaction()) {
            try {
                if (conn != null) {
                    if (isUpdate && !conn.getAutoCommit()) {
                        conn.commit();
                    }
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new BeetlSQLException(1, (Throwable)e);
            }
        }
    }

    default public DataSource getMasterSource() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6570\u636e\u6e90");
    }

    default public DataSource[] getSlaves() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6570\u636e\u6e90");
    }

    default public void forceBegin(DataSource dataSource) {
        forceDs.set(dataSource);
    }

    default public void forceEnd() {
        forceDs.set(null);
    }

    default public DataSource getForceDataSource() {
        return forceDs.get();
    }
}

