/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.Table;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.CaseInsensitiveOrderSet;

public class ClassDesc {
    protected Class targetClass;
    protected TableDesc table;
    protected NameConversion nc;
    protected Set<String> properties = new CaseInsensitiveOrderSet();
    protected Set<String> cols = new CaseInsensitiveOrderSet();
    protected List<String> idProperties = new ArrayList<String>(3);
    protected List<String> idCols = new ArrayList<String>(3);
    protected Map<String, Object> idMethods = new CaseInsensitiveHashMap();
    protected ClassAnnotation ca = null;

    public ClassDesc(Class c, TableDesc table, NameConversion nc) {
        this.targetClass = c;
        this.nc = nc;
        this.ca = ClassAnnotation.getClassAnnotation(c);
        PropertyDescriptor[] ps = this.ca.getPropertyDescriptor(c);
        Set<String> ids = table.getIdNames();
        Table tableAnnotation = c.getAnnotation(Table.class);
        if (tableAnnotation != null && tableAnnotation.assignID()) {
            ids = this.findIdColByAnnotation(c, ps);
            if (ids.isEmpty()) {
                throw new BeetlSQLException(7, "\u4f7f\u7528@Table(assignId=true) in " + c + " \u4f46\u662f\u672a\u53d1\u73b0@AssingId");
            }
            table.getIdNames().clear();
            ids.forEach(id -> table.addIdName((String)id));
        }
        CaseInsensitiveHashMap tempMap = new CaseInsensitiveHashMap();
        for (PropertyDescriptor p : ps) {
            String property;
            String col;
            if (p.getReadMethod() == null || BeanKit.getWriteMethod((PropertyDescriptor)p, (Class)c) == null || (col = nc.getColName(c, property = p.getName())) == null) continue;
            tempMap.put(col, (Object)p);
        }
        for (String col : table.getCols()) {
            if (!tempMap.containsKey((Object)col)) continue;
            PropertyDescriptor p = (PropertyDescriptor)tempMap.get((Object)col);
            String attrName = p.getName();
            this.addAttribute(col, attrName);
            if (!ids.contains(col)) continue;
            this.addIdAttribute(col, attrName);
            Method readMethod = p.getReadMethod();
            this.idMethods.put(attrName, readMethod);
        }
    }

    private void addIdAttribute(String col, String attr) {
        this.idProperties.add(attr);
        this.idCols.add(col);
    }

    private void addAttribute(String col, String attr) {
        this.properties.add(attr);
        this.cols.add(col);
    }

    protected ClassDesc(TableDesc table, NameConversion nc) {
        this.table = table;
        this.nc = nc;
        for (String colName : table.getCols()) {
            String prop = nc.getPropertyName(colName);
            this.properties.add(prop);
            ColDesc colDes = table.getColDesc(colName);
            this.cols.add(colName);
        }
        for (String name : table.getIdNames()) {
            this.idProperties.add(nc.getPropertyName(name));
        }
    }

    public ClassDesc buildVirtualClass(TableDesc table, NameConversion nc) {
        return new ClassDesc(table, nc);
    }

    public List<String> getIdAttrs() {
        return this.idProperties;
    }

    public String getIdAttr() {
        if (this.idProperties.size() > 1) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u591a\u4e3b\u952e");
        }
        return this.idProperties.get(0);
    }

    public List<String> getIdCols() {
        return this.idCols;
    }

    public Set<String> getAttrs() {
        return this.properties;
    }

    public Set<String> getInCols() {
        return this.cols;
    }

    public Map<String, Object> getIdMethods() {
        return this.idMethods;
    }

    public ClassAnnotation getClassAnnotation() {
        return this.ca;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Set<String> findIdColByAnnotation(Class cls, PropertyDescriptor[] ps) {
        CaseInsensitiveOrderSet idCols = new CaseInsensitiveOrderSet();
        for (PropertyDescriptor pd : ps) {
            String name = pd.getName();
            List list = BeanKit.getAllAnnotation((Class)cls, (String)name);
            for (Annotation annotation : list) {
                if (!(annotation instanceof AssignID)) continue;
                idCols.add(this.nc.getColName(cls, name));
            }
        }
        return idCols;
    }
}

