/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.range.RangeSql;

public class PostgresStyle
extends AbstractDBStyle {
    RangeSql rangeSql = new PostgresRange(this);

    @Override
    public int getIdType(Class c, String idProperty) {
        List ans = BeanKit.getAllAnnotation((Class)c, (String)idProperty);
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
        }
        return idType;
    }

    @Override
    public String getName() {
        return "postgres";
    }

    @Override
    public int getDBType() {
        return 3;
    }

    @Override
    public RangeSql getRangeSql() {
        return this.rangeSql;
    }

    @Override
    public String getSeqValue(String seqName) {
        return "nextval('" + seqName + "')";
    }

    @Override
    public String getDefaultSchema() {
        return "public";
    }

    static class PostgresRange
    implements RangeSql {
        PostgresStyle style;

        public PostgresRange(PostgresStyle style) {
            this.style = style;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            offset = PageParamKit.postgresOffset(this.style.offsetStartZero, offset);
            int capacity = jdbcSql.length() + 50;
            StringBuilder builder = new StringBuilder(capacity);
            builder.append("select _a.* from ( ").append(jdbcSql).append(" ) _a ");
            builder.append("limit ").append(limit).append(" offset ").append(offset);
            return builder.toString();
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            String pageSql = "select _a.* from ( \n" + template + this.style.getOrderBy() + " \n) _a  limit " + this.style.appendExpress("_pageSize") + " offset " + this.style.appendExpress("_pageOffset");
            return pageSql;
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            paras.put("_pageOffset", offset - (long)(this.style.offsetStartZero ? 0 : 1));
            paras.put("_pageSize", size);
        }
    }
}

