/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.sql.Connection;
import java.util.Map;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DSTransactionManager;
import org.beetl.sql.core.ExecuteContext;

public class ConditionalConnectionSource
implements ConnectionSource {
    Policy policy;
    Map<String, ConnectionSource> all;
    ConnectionSource defaultCs;

    public ConditionalConnectionSource(Policy policy, Map<String, ConnectionSource> all) {
        this.all = all;
        String defaultName = policy.getMasterName();
        this.defaultCs = all.get(defaultName);
        if (this.defaultCs == null) {
            throw new IllegalArgumentException("\u6839\u636e " + defaultName + " \u627e\u4e0d\u5230\u5bf9\u5e94\u7684ConnectionSource");
        }
        this.policy = policy;
    }

    @Override
    public Connection getMasterConn() {
        return this.defaultCs.getMasterConn();
    }

    @Override
    public Connection getMetaData() {
        return this.getMasterConn();
    }

    @Override
    public Connection getConn(ExecuteContext ctx, boolean isUpdate) {
        String name = this.policy.getConnectionSourceName(ctx, isUpdate);
        ConnectionSource cs = this.all.get(name);
        if (cs == null) {
            throw new IllegalArgumentException("\u6839\u636e " + name + " \u627e\u4e0d\u5230\u5bf9\u5e94\u7684ConnectionSource");
        }
        return cs.getConn(ctx, isUpdate);
    }

    @Override
    public boolean isTransaction() {
        return DSTransactionManager.inTrans();
    }

    public static interface Policy {
        public String getConnectionSourceName(ExecuteContext var1, boolean var2);

        public String getMasterName();
    }
}

