/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SocketFinder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SocketConnector
implements Runnable {
    private final Socket socket;
    private final SocketFinder socketFinder;
    private final InetSocketAddress inetSocketAddress;
    private final int timeoutInMilliseconds;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SocketConnector");
    private final String traceID;
    private final String threadID;
    private static long lastThreadID = 0L;

    SocketConnector(Socket socket, InetSocketAddress inetSocketAddress, int n, SocketFinder socketFinder) {
        this.socket = socket;
        this.inetSocketAddress = inetSocketAddress;
        this.timeoutInMilliseconds = n;
        this.socketFinder = socketFinder;
        this.threadID = Long.toString(SocketConnector.nextThreadID());
        this.traceID = "SocketConnector:" + this.threadID + "(" + socketFinder.toString() + ")";
    }

    public void run() {
        IOException iOException = null;
        SocketFinder.Result result = this.socketFinder.getResult();
        if (result.equals((Object)SocketFinder.Result.UNKNOWN)) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " connecting to InetSocketAddress:" + this.inetSocketAddress + " with timeout:" + this.timeoutInMilliseconds);
                }
                this.socket.connect(this.inetSocketAddress, this.timeoutInMilliseconds);
            }
            catch (IOException iOException2) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " exception:" + iOException2.getClass() + " with message:" + iOException2.getMessage() + " occured while connecting to InetSocketAddress:" + this.inetSocketAddress);
                }
                iOException = iOException2;
            }
            this.socketFinder.updateResult(this.socket, iOException, this.toString());
        }
    }

    public String toString() {
        return this.traceID;
    }

    private static synchronized long nextThreadID() {
        if (lastThreadID == Long.MAX_VALUE) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resetting the Id count");
            }
            lastThreadID = 1L;
        } else {
            ++lastThreadID;
        }
        return lastThreadID;
    }
}

