/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.db;

import com.opensymphony.db.ServerProp;
import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DBHelper {
    private static Logger logger = Logger.getLogger(DBHelper.class);
    private static Properties serverInfo;

    public static void exeSqls(List<Object[]> sqlAndParams) throws SQLException {
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            try {
                conn = DBHelper.getConn();
                conn.setAutoCommit(false);
                for (Object[] record : sqlAndParams) {
                    pst = conn.prepareStatement(record[0].toString());
                    Object[] params = (Object[])record[1];
                    if (params != null && params.length > 0) {
                        pst = DBHelper.initParams(pst, params);
                    }
                    pst.executeUpdate();
                }
                conn.commit();
            }
            catch (Throwable e) {
                e.printStackTrace();
                conn.rollback();
                DBHelper.clear(conn, pst, null);
            }
        }
        finally {
            DBHelper.clear(conn, pst, null);
        }
    }

    public static void exeSqls(Object[][] sqlAndParams) throws SQLException {
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            try {
                conn = DBHelper.getConn();
                conn.setAutoCommit(false);
                Object[][] objectArray = sqlAndParams;
                int n = sqlAndParams.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] record = objectArray[n2];
                    pst = conn.prepareStatement(record[0].toString());
                    Object[] params = (Object[])record[1];
                    if (params != null && params.length > 0) {
                        pst = DBHelper.initParams(pst, params);
                    }
                    pst.executeUpdate();
                    ++n2;
                }
                conn.commit();
            }
            catch (Throwable e) {
                e.printStackTrace();
                conn.rollback();
                DBHelper.clear(conn, pst, null);
            }
        }
        finally {
            DBHelper.clear(conn, pst, null);
        }
    }

    public static Object getSingal(String sql, Object[] ... params) {
        ResultSet rs;
        PreparedStatement pst;
        Connection conn;
        block5: {
            Object object;
            conn = null;
            pst = null;
            rs = null;
            try {
                conn = DBHelper.getConn();
                pst = conn.prepareStatement(sql);
                if (params != null && params.length > 0) {
                    pst = DBHelper.initParams(pst, params[0]);
                }
                if (!(rs = pst.executeQuery()).next()) break block5;
                object = rs.getObject(1);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DBHelper.clear(conn, pst, rs);
                    throw throwable;
                }
            }
            DBHelper.clear(conn, pst, rs);
            return object;
        }
        DBHelper.clear(conn, pst, rs);
        return null;
    }

    public static String getSingalClob(String sql, Object[] ... params) {
        ResultSet rs;
        PreparedStatement pst;
        Connection conn;
        block7: {
            String string;
            conn = null;
            pst = null;
            rs = null;
            try {
                conn = DBHelper.getConn();
                pst = conn.prepareStatement(sql);
                if (params != null && params.length > 0) {
                    pst = DBHelper.initParams(pst, params[0]);
                }
                if (!(rs = pst.executeQuery()).next()) break block7;
                String value = "";
                Clob clob = (Clob)rs.getObject(1);
                if (clob != null) {
                    Reader reader = clob.getCharacterStream();
                    BufferedReader br = new BufferedReader(reader);
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        value = String.valueOf(value) + line;
                    }
                }
                string = value;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DBHelper.clear(conn, pst, rs);
                    throw throwable;
                }
            }
            DBHelper.clear(conn, pst, rs);
            return string;
        }
        DBHelper.clear(conn, pst, rs);
        return null;
    }

    public static int exeSql(String sql, Object[] ... params) {
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = DBHelper.getConn();
            pst = conn.prepareStatement(sql);
            if (params != null && params.length > 0 && params != null && params.length > 0) {
                pst = DBHelper.initParams(pst, params[0]);
            }
            int n = pst.executeUpdate();
            return n;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            DBHelper.clear(conn, pst, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List queryOneCol(String sql, Object[] ... params) {
        ArrayList<Object> arrayList;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            ResultSetMetaData rsmd;
            int numberOfColumns;
            conn = DBHelper.getConn();
            pst = conn.prepareStatement(sql);
            if (params != null && params.length > 0 && params != null && params.length > 0) {
                pst = DBHelper.initParams(pst, params[0]);
            }
            if ((numberOfColumns = (rsmd = (rs = pst.executeQuery()).getMetaData()).getColumnCount()) > 1) {
                throw new RuntimeException("\u67e5\u8be2\u7684\u5217\u6570\u53ea\u80fd\u662f\u4e00\u5217!");
            }
            while (true) {
                if (!rs.next()) {
                    arrayList = result;
                    break;
                }
                result.add(rs.getObject(1));
            }
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DBHelper.clear(conn, pst, rs);
                throw throwable;
            }
        }
        DBHelper.clear(conn, pst, rs);
        return arrayList;
    }

    public static List<Map<String, Object>> query(String sql, Object[] ... params) {
        ArrayList<Map<String, Object>> arrayList;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<Map<String, Object>> list = null;
        try {
            conn = DBHelper.getConn();
            pst = conn.prepareStatement(sql);
            if (params != null && params.length > 0 && params != null && params.length > 0) {
                pst = DBHelper.initParams(pst, params[0]);
            }
            rs = pst.executeQuery();
            list = new ArrayList<Map<String, Object>>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(numberOfColumns);
                int r = 1;
                while (r < numberOfColumns + 1) {
                    map.put(rsmd.getColumnName(r).toUpperCase(), rs.getObject(r));
                    ++r;
                }
                list.add(map);
            }
            arrayList = list;
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DBHelper.clear(conn, pst, rs);
                throw throwable;
            }
        }
        DBHelper.clear(conn, pst, rs);
        return arrayList;
    }

    public static String queryAndReturnArrayStr(String sql, Object[] ... params) {
        ResultSet rs;
        PreparedStatement pst;
        Connection conn;
        block8: {
            String string;
            conn = null;
            pst = null;
            rs = null;
            Object list = null;
            try {
                conn = DBHelper.getConn();
                pst = conn.prepareStatement(sql);
                if (params != null && params.length > 0 && params != null && params.length > 0) {
                    pst = DBHelper.initParams(pst, params[0]);
                }
                if ((rs = pst.executeQuery()) == null) break block8;
                StringBuffer json = new StringBuffer();
                json.append("[");
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                while (rs.next()) {
                    String temp = "[";
                    int i = 0;
                    while (i < colCount) {
                        Object o = rs.getObject(i + 1);
                        temp = String.valueOf(temp) + "'" + (o == null ? "" : o.toString()) + "',";
                        ++i;
                    }
                    temp = temp.substring(0, temp.length() - 1);
                    temp = String.valueOf(temp) + "],";
                    json.append(temp);
                }
                if (json.length() > 1) {
                    json = json.deleteCharAt(json.length() - 1);
                }
                json.append("]");
                string = json.toString();
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DBHelper.clear(conn, pst, rs);
                    throw throwable;
                }
            }
            DBHelper.clear(conn, pst, rs);
            return string;
        }
        DBHelper.clear(conn, pst, rs);
        return null;
    }

    public static String queryAndReturnJsonStr(String sql, Object[] ... params) {
        ResultSet rs;
        PreparedStatement pst;
        Connection conn;
        block8: {
            String string;
            conn = null;
            pst = null;
            rs = null;
            try {
                conn = DBHelper.getConn();
                pst = conn.prepareStatement(sql);
                if (params != null && params.length > 0 && params != null && params.length > 0) {
                    pst = DBHelper.initParams(pst, params[0]);
                }
                if ((rs = pst.executeQuery()) == null) break block8;
                StringBuffer json = new StringBuffer();
                json.append("[");
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                while (rs.next()) {
                    String temp = "{";
                    int i = 0;
                    while (i < colCount) {
                        Object o = rs.getObject(i + 1);
                        int colType = rsmd.getColumnType(i + 1);
                        temp = colType == 4 || colType == 8 || colType == 6 || colType == -5 || colType == 5 ? String.valueOf(temp) + rsmd.getColumnName(i + 1) + ":" + (o == null ? "" : o.toString()) + "," : String.valueOf(temp) + rsmd.getColumnName(i + 1) + ":'" + (o == null ? "" : o.toString()) + "',";
                        ++i;
                    }
                    temp = temp.substring(0, temp.length() - 1);
                    temp = String.valueOf(temp) + "},";
                    json.append(temp);
                }
                if (json.length() > 1) {
                    json = json.deleteCharAt(json.length() - 1);
                }
                json.append("]");
                string = json.toString();
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DBHelper.clear(conn, pst, rs);
                    throw throwable;
                }
            }
            DBHelper.clear(conn, pst, rs);
            return string;
        }
        DBHelper.clear(conn, pst, rs);
        return null;
    }

    private static void clear(Connection conn, PreparedStatement pst, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u5de5\u4f5c\u6d41\u4e2d\u6570\u636e\u5e93\u6267\u884c\u7c7b\u4e2d\u5173\u95edsession\u5931\u8d25!");
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private static PreparedStatement initParams(PreparedStatement _pst, Object[] params) {
        try {
            int i = 0;
            while (i < params.length) {
                _pst.setObject(i + 1, params[i]);
                ++i;
            }
            return _pst;
        }
        catch (Throwable e) {
            logger.error((Object)"\u5de5\u4f5c\u6d41\u4e2d\u6570\u636e\u5e93\u6267\u884c\u7c7b\u4e2d\u521d\u59cb\u5316\u53c2\u6570\u5931\u8d25!");
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static Connection getConn() {
        try {
            String dbType;
            Connection _conn = null;
            if (serverInfo == null) {
                serverInfo = new ServerProp().loadServerInfo();
            }
            if ("jndi".equalsIgnoreCase(dbType = serverInfo.getProperty("ds_type"))) {
                String dsJndi = serverInfo.getProperty("ds_jndi");
                logger.info((Object)("###\u4ece\u6570\u636e\u6e90\u53d6\u5f97\u6570\u636e\u5e93\u8fde\u63a5\uff0cjndi\u8fde\u63a5\u5b57\u7b26\u4e32\u4e3a\uff1a" + dsJndi));
                InitialContext ic = new InitialContext();
                DataSource ds = (DataSource)ic.lookup(dsJndi);
                _conn = ds.getConnection();
            } else {
                String driver = serverInfo.getProperty("db_driver");
                String url = serverInfo.getProperty("db_url");
                String user = serverInfo.getProperty("db_user");
                String pwd = serverInfo.getProperty("db_pwd");
                Class.forName(driver);
                _conn = DriverManager.getConnection(url, user, pwd);
            }
            return _conn;
        }
        catch (Throwable e) {
            logger.error((Object)"\u5de5\u4f5c\u6d41\u4e2d\u6570\u636e\u5e93\u6267\u884c\u7c7b\u4e2d\u53d6\u5f97\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!");
            logger.error((Object)e);
            throw new RuntimeException();
        }
    }

    public static void main(String[] args) {
        DBHelper.getConn();
    }
}

