/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.guochuang.gov.data.base.bean.LoginUser;
import com.guochuang.gov.data.common.exception.BusiException;
import com.guochuang.gov.data.sys.SysUserStatus;
import com.guochuang.gov.data.sys.entity.SysUser;
import com.guochuang.gov.data.sys.service.SysRoleUserService;
import com.guochuang.gov.data.sys.service.SysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    @Autowired
    private SysUserService userService;
    @Autowired
    private SysRoleUserService sysRoleUserService;

    public UserDetails loadUserByUsername(String username) {
        SysUser user = this.userService.findByLoginCode(username);
        if (user == null) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)username);
            throw new BusiException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (SysUserStatus.LOCK.getCode().equals(user.getStatus())) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u5df2\u88ab\u9501\u5b9a.", (Object)username);
            throw new BusiException("\u7528\u6237\u5df2\u88ab\u9501\u5b9a");
        }
        if (SysUserStatus.DISABLE.getCode().equals(user.getStatus())) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u5df2\u505c\u7528.", (Object)username);
            throw new BusiException("\u7528\u6237\u5df2\u505c\u7528");
        }
        return this.buildLoginUser(user);
    }

    private LoginUser buildLoginUser(SysUser user) {
        LoginUser loginUser = new LoginUser();
        loginUser.setUserId(user.getUserId());
        loginUser.setLoginCode(user.getLoginCode());
        loginUser.setUserName(user.getUserName());
        loginUser.setPwd(user.getPwd());
        loginUser.setRoleId(this.sysRoleUserService.getRoleId(user.getUserId()));
        return loginUser;
    }
}

