/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.guochuang.gov.data.base.security.util.AuthUtil;
import com.guochuang.gov.data.base.util.MemCache;
import com.guochuang.gov.data.base.util.SysUtil;
import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.exception.BusiException;
import com.guochuang.gov.data.common.util.base.StringUtil;
import com.guochuang.gov.data.sys.dao.SysUserMapper;
import com.guochuang.gov.data.sys.entity.SysUser;
import com.guochuang.gov.data.sys.service.BaseDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserService {
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private BaseDataService baseDataService;

    public PageObject query(String fuzzy, int pageNum, int pageSize) {
        Page<SysUser> ipage = this.sysUserMapper.query((Page<SysUser>)new Page((long)pageNum, (long)pageSize), StringUtil.getLike((String)fuzzy));
        for (SysUser user : ipage.getRecords()) {
            user.setStatusText(MemCache.getDicText((String)"userStatus", (String)(user.getStatus() + "")));
        }
        return SysUtil.converTo(ipage);
    }

    public void save(SysUser entity) {
        if (entity.getUserId() == null) {
            entity.setPwd(AuthUtil.encryptPassword((String)"1234"));
            this.sysUserMapper.insert((Object)entity);
        } else {
            this.sysUserMapper.updateById((Object)entity);
        }
        this.baseDataService.setUserMap();
    }

    public void del(Long userId) {
        this.sysUserMapper.deleteById(userId);
    }

    public void insert(List<SysUser> list) {
        for (SysUser sysUser : list) {
            this.sysUserMapper.insert((Object)sysUser);
        }
    }

    public void update(List<SysUser> list) {
        for (SysUser sysUser : list) {
            this.sysUserMapper.updateById((Object)sysUser);
        }
    }

    public void insert(SysUser sysUser) {
        this.sysUserMapper.insert((Object)sysUser);
    }

    public void update(SysUser sysUser) {
        this.sysUserMapper.updateById((Object)sysUser);
    }

    public SysUser findById(Long userId) {
        return (SysUser)((Object)this.sysUserMapper.selectById(userId));
    }

    public SysUser findByLoginCode(String loginCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"login_code", (Object)loginCode);
        return (SysUser)((Object)this.sysUserMapper.selectOne((Wrapper)queryWrapper));
    }

    public List<SysUser> findAll() {
        return this.sysUserMapper.selectList(null);
    }

    public void editPwd(String oldPwd, String newPwd) {
        SysUser sysUser = this.findById(SysUtil.getLoginUser().getUserId());
        if (AuthUtil.matchesPassword((String)oldPwd, (String)sysUser.getPwd())) {
            throw new BusiException("\u539f\u59cb\u5bc6\u7801\u4e0d\u6b63\u786e!");
        }
        sysUser.setPwd(AuthUtil.encryptPassword((String)newPwd));
        this.sysUserMapper.updateById((Object)sysUser);
    }

    public void resetPwd(Long userId) {
        SysUser sysUser = this.findById(SysUtil.getUserId());
        sysUser.setPwd(AuthUtil.encryptPassword((String)"1234"));
        this.sysUserMapper.updateById((Object)sysUser);
    }

    public SysUser findByOaUserId(String oaUserId) {
        return (SysUser)((Object)this.sysUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysUser::getOaUserId, (Object)oaUserId)));
    }
}

