/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.guochuang.gov.data.base.util.SysUtil;
import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.util.base.ObjectUtil;
import com.guochuang.gov.data.common.util.base.StringUtil;
import com.guochuang.gov.data.sys.dao.SysRoleUserMapper;
import com.guochuang.gov.data.sys.entity.SysRoleUser;
import com.guochuang.gov.data.sys.entity.SysUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleUserService {
    @Autowired
    private SysRoleUserMapper sysRoleUserMapper;

    public PageObject querySelUser(Long roleId, String fuzzy, int pageNum, int pageSize) {
        Page<SysUser> ipage = new Page<SysUser>((long)pageNum, (long)pageSize);
        if (!ObjectUtil.isEmpty((Object)fuzzy)) {
            fuzzy = StringUtil.getLike((String)fuzzy);
        }
        ipage = this.sysRoleUserMapper.querySelUser(roleId, fuzzy, ipage);
        return SysUtil.converTo(ipage);
    }

    public PageObject queryUnSelUser(Long roleId, String fuzzy, int pageNum, int pageSize) {
        Page<SysUser> ipage = new Page<SysUser>((long)pageNum, (long)pageSize);
        if (!ObjectUtil.isEmpty((Object)fuzzy)) {
            fuzzy = StringUtil.getLike((String)fuzzy);
        }
        ipage = this.sysRoleUserMapper.queryUnSelUser(roleId, fuzzy, ipage);
        return SysUtil.converTo(ipage);
    }

    public void selUser(Long roleId, String userIds) {
        String[] userIdArr;
        for (String userId : userIdArr = userIds.split(",")) {
            SysRoleUser entity = new SysRoleUser();
            entity.setRoleId(roleId);
            entity.setUserId(Long.parseLong(userId));
            this.sysRoleUserMapper.insert(entity);
        }
    }

    public void unSelUser(Long roleId, String userIds) {
        this.sysRoleUserMapper.del(roleId, userIds.split(","));
    }

    public Long getRoleId(Long userId) {
        return this.sysRoleUserMapper.getRoleId(userId);
    }

    public void deleteAll() {
        this.sysRoleUserMapper.delete(null);
    }

    public void insert(List<SysRoleUser> roleUserList) {
        roleUserList.forEach(arg_0 -> ((SysRoleUserMapper)this.sysRoleUserMapper).insert(arg_0));
    }

    public void insert(SysRoleUser sysRoleUser) {
        this.sysRoleUserMapper.insert(sysRoleUser);
    }

    public void deleteByUserId(Long userId) {
        this.sysRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleUser::getUserId, (Object)userId));
    }

    public List<String> getUserRoles(Long userId) {
        return this.sysRoleUserMapper.getUserRoles(userId);
    }
}

