/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.guochuang.gov.data.base.bean.TreeNode;
import com.guochuang.gov.data.common.util.base.ObjectUtil;
import com.guochuang.gov.data.sys.dao.SysRoleMenuMapper;
import com.guochuang.gov.data.sys.entity.SysMenu;
import com.guochuang.gov.data.sys.entity.SysRoleMenu;
import com.guochuang.gov.data.sys.vo.MetaVo;
import com.guochuang.gov.data.sys.vo.RouterVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleMenuService {
    @Autowired
    private SysRoleMenuMapper sysRoleMenuMapper;

    public List<TreeNode> getSelMenuTree(Long roleId) {
        List<SysMenu> list = this.sysRoleMenuMapper.getSelMenuTree(roleId);
        TreeNode root = this.getRoot();
        root.setChildren(this.buildTree(0L, list));
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        result.add(root);
        return result;
    }

    public List<TreeNode> getUnSelMenuTree(Long roleId) {
        List<SysMenu> list = this.sysRoleMenuMapper.getUnSelMenuTree(roleId);
        TreeNode root = this.getRoot();
        root.setChildren(this.buildTree(0L, list));
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        result.add(root);
        return result;
    }

    private List<TreeNode> buildTree(long pid, final List<SysMenu> list) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        for (SysMenu menu : list) {
            if (menu.getMenuPid() != pid) continue;
            TreeNode node = new TreeNode();
            node.setId(menu.getMenuId().toString());
            node.setLabel(menu.getMenuName());
            node.setChildren(this.buildTree(menu.getMenuId(), list));
            if (menu.getIsFile().equals("0") && node.getChildren().isEmpty()) continue;
            children.add(node);
        }
        children.sort(new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                return SysRoleMenuService.this.getOrderNum(o1, (List<SysMenu>)list) - SysRoleMenuService.this.getOrderNum(o2, (List<SysMenu>)list);
            }
        });
        return children;
    }

    private int getOrderNum(TreeNode node, List<SysMenu> list) {
        for (SysMenu menu : list) {
            if (!menu.getMenuId().equals(Long.parseLong(node.getId()))) continue;
            return ObjectUtil.obj2Int((Object)menu.getOrderNum());
        }
        return 0;
    }

    private TreeNode getRoot() {
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setLabel("\u6839\u8282\u70b9");
        return root;
    }

    public void selMenu(Long roleId, String menuIds) {
        String[] menuIdArr;
        for (String menuId : menuIdArr = menuIds.split(",")) {
            if ("0".equals(menuId)) continue;
            SysRoleMenu entity = new SysRoleMenu();
            entity.setRoleId(roleId);
            entity.setMenuId(Long.parseLong(menuId));
            this.sysRoleMenuMapper.insert(entity);
        }
    }

    public void unSelMenu(Long roleId, String menuIds) {
        this.sysRoleMenuMapper.del(roleId, menuIds.split(","));
    }

    public List<RouterVo> getUserMenus(Long userId) {
        List<SysMenu> list = this.sysRoleMenuMapper.getUserMenus(userId);
        List<RouterVo> result = this.buildMenu(0L, list);
        return result;
    }

    private List<RouterVo> buildMenu(Long pid, final List<SysMenu> list) {
        ArrayList<RouterVo> children = new ArrayList<RouterVo>();
        for (SysMenu menu : list) {
            if (!menu.getMenuPid().equals(pid)) continue;
            RouterVo node = new RouterVo();
            node.setName(menu.getRoute());
            node.setPath("/" + menu.getRoute());
            node.setComponent(menu.getMenuUrl());
            MetaVo metaVo = new MetaVo();
            metaVo.setTitle(menu.getMenuName());
            metaVo.setIcon(menu.getIcon());
            node.setMeta(metaVo);
            node.setChildren(this.buildMenu(menu.getMenuId(), list));
            if (!node.getChildren().isEmpty()) {
                node.setAlwaysShow(true);
                node.setRedirect("noRedirect");
            }
            if (menu.getIsFile().equals("0") && node.getChildren().isEmpty()) continue;
            children.add(node);
        }
        children.sort(new Comparator<RouterVo>(){

            @Override
            public int compare(RouterVo o1, RouterVo o2) {
                return SysRoleMenuService.this.getOrderNum(o1, (List<SysMenu>)list) - SysRoleMenuService.this.getOrderNum(o2, (List<SysMenu>)list);
            }
        });
        return children;
    }

    private int getOrderNum(RouterVo node, List<SysMenu> list) {
        for (SysMenu menu : list) {
            if (!menu.getRoute().equals(node.getName())) continue;
            return ObjectUtil.obj2Int((Object)menu.getOrderNum());
        }
        return 0;
    }

    public void deleteAll() {
        this.sysRoleMenuMapper.delete(null);
    }

    public void insert(List<SysRoleMenu> roleUserList) {
        roleUserList.forEach(arg_0 -> ((SysRoleMenuMapper)this.sysRoleMenuMapper).insert(arg_0));
    }

    public void insert(SysRoleMenu sysRoleMenu) {
        this.sysRoleMenuMapper.insert(sysRoleMenu);
    }

    public void deleteByMenuId(Long menuId) {
        this.sysRoleMenuMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleMenu::getMenuId, (Object)menuId));
    }
}

