/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.alibaba.fastjson.JSON;
import com.guochuang.gov.data.base.bean.TreeNode;
import com.guochuang.gov.data.base.util.TreeBuildUtil;
import com.guochuang.gov.data.sys.dao.SysMenuMapper;
import com.guochuang.gov.data.sys.dao.SysRoleMenuMapper;
import com.guochuang.gov.data.sys.entity.SysMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuService {
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysRoleMenuMapper sysRoleMenuMapper;

    public void save(SysMenu entity) {
        if (entity.getMenuId() == null) {
            this.sysMenuMapper.insert((Object)entity);
        } else {
            SysMenu model = (SysMenu)((Object)this.sysMenuMapper.selectById(entity.getMenuId()));
            this.sysMenuMapper.updateById((Object)entity);
            if ("1".equals(model.getIsFile()) && "0".equals(entity.getIsFile())) {
                this.sysRoleMenuMapper.delByMenuId(entity.getMenuId());
            }
        }
    }

    public void del(Long menuId) {
        this.sysMenuMapper.deleteById(menuId);
        this.sysRoleMenuMapper.delByMenuId(menuId);
    }

    public SysMenu findById(Long menuId) {
        return (SysMenu)((Object)this.sysMenuMapper.selectById(menuId));
    }

    public List<TreeNode> getMenuTree() {
        List<Map<String, Object>> list = this.sysMenuMapper.list();
        List trees = TreeBuildUtil.buildTree(list);
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setLabel("\u6839\u8282\u70b9");
        root.setChildren(trees);
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        result.add(root);
        return result;
    }

    public void saveCurrentDirs(String data) {
        List minMenus = JSON.parseArray((String)data, SysMenu.class);
        for (SysMenu minMenu : minMenus) {
            SysMenu sysMenu = this.findById(minMenu.getMenuId());
            sysMenu.setMenuPid(minMenu.getMenuPid());
            this.save(sysMenu);
        }
    }

    public List<SysMenu> list() {
        return this.sysMenuMapper.selectList(null);
    }

    public void insert(List<SysMenu> insertMenus) {
        insertMenus.forEach(arg_0 -> ((SysMenuMapper)this.sysMenuMapper).insert(arg_0));
    }

    public void update(List<SysMenu> updateMenus) {
        updateMenus.forEach(arg_0 -> ((SysMenuMapper)this.sysMenuMapper).updateById(arg_0));
    }

    public void insert(SysMenu sysMenu) {
        this.sysMenuMapper.insert((Object)sysMenu);
    }

    public void update(SysMenu sysMenu) {
        this.sysMenuMapper.updateById((Object)sysMenu);
    }
}

