/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.guochuang.gov.data.base.bean.LoginUser;
import com.guochuang.gov.data.base.util.HttpUtil;
import com.guochuang.gov.data.base.util.MemCache;
import com.guochuang.gov.data.base.util.SysUtil;
import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.util.base.DateUtil;
import com.guochuang.gov.data.common.util.base.StringUtil;
import com.guochuang.gov.data.sys.dao.SysLoginLogMapper;
import com.guochuang.gov.data.sys.entity.SysLoginLog;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysLoginLogService {
    @Autowired
    private SysLoginLogMapper sysLoginLogMapper;

    public PageObject query(String fuzzy, int pageNum, int pageSize) {
        Page ipage = this.sysLoginLogMapper.query(StringUtil.getLike((String)fuzzy), new Page((long)pageNum, (long)pageSize));
        PageObject pageObject = SysUtil.converTo((Page)ipage);
        for (Map map : pageObject.getRows()) {
            map.put("loginTime", DateUtil.formatDateTime(map.get("loginTime")));
            map.put("loginTypeText", MemCache.getDicText((String)"loginType", (String)StringUtil.null2String(map.get("loginType"))));
            map.put("loginStatusText", MemCache.getDicText((String)"loginStatus", (String)StringUtil.null2String(map.get("loginStatus"))));
        }
        return pageObject;
    }

    public void save(SysLoginLog entity) {
        if (entity.getLoginLogId() == null) {
            this.sysLoginLogMapper.insert(entity);
        } else {
            this.sysLoginLogMapper.updateById(entity);
        }
    }

    public void del(Long loginLogId) {
        this.sysLoginLogMapper.deleteById(loginLogId);
    }

    public SysLoginLog findById(Long loginLogId) {
        return (SysLoginLog)this.sysLoginLogMapper.selectById(loginLogId);
    }

    public void insertLoginLog() {
        LoginUser loginUser = SysUtil.getLoginUser();
        this.insertLoginLog(loginUser);
    }

    public void insertLoginLog(LoginUser loginUser) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setIp(HttpUtil.getIp());
        sysLoginLog.setLoginCode(loginUser.getLoginCode());
        sysLoginLog.setLoginName(loginUser.getUserName());
        sysLoginLog.setLoginTime(new Date());
        sysLoginLog.setLoginStatus("1");
        this.save(sysLoginLog);
    }
}

