/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.guochuang.gov.data.base.util.MemCache;
import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.util.base.StringUtil;
import com.guochuang.gov.data.sys.dao.SysDicDataMapper;
import com.guochuang.gov.data.sys.entity.SysDicData;
import com.guochuang.gov.data.sys.service.BaseDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDicDataService {
    @Autowired
    private SysDicDataMapper sysDicDataMapper;
    @Autowired
    private BaseDataService baseDataService;

    public PageObject query(String fuzzyData, String dicTypeCode) {
        List<SysDicData> list = this.sysDicDataMapper.query(StringUtil.getLike((String)fuzzyData), dicTypeCode);
        for (SysDicData dicData : list) {
            dicData.setStatusText(MemCache.getDicText((String)"status", (String)dicData.getStatus()));
        }
        return new PageObject(Long.valueOf(list.size()), list);
    }

    public void save(SysDicData entity) {
        if (entity.getDicId() == null) {
            this.sysDicDataMapper.insert((Object)entity);
        } else {
            this.sysDicDataMapper.updateById((Object)entity);
        }
        this.baseDataService.setDicMap();
    }

    public void del(Long dicId) {
        this.sysDicDataMapper.deleteById(dicId);
    }

    public SysDicData findById(Long dicId) {
        return (SysDicData)((Object)this.sysDicDataMapper.selectById(dicId));
    }
}

