/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.guochuang.gov.data.base.util.MemCache;
import com.guochuang.gov.data.base.util.SysUtil;
import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.util.base.StringUtil;
import com.guochuang.gov.data.sys.dao.SysConfigMapper;
import com.guochuang.gov.data.sys.entity.SysConfig;
import com.guochuang.gov.data.sys.service.BaseDataService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigService {
    @Autowired
    private SysConfigMapper sysConfigMapper;
    @Autowired
    private BaseDataService baseDataService;

    public PageObject query(String fuzzy, String configType, int pageNum, int pageSize) {
        Page ipage = this.sysConfigMapper.query(StringUtil.getLike((String)fuzzy), configType, new Page((long)pageNum, (long)pageSize));
        PageObject pageObject = SysUtil.converTo((Page)ipage);
        for (Map map : pageObject.getRows()) {
            map.put("configTypeName", MemCache.getDicText((String)"configType", (String)StringUtil.null2String(map.get("configType"))));
        }
        return pageObject;
    }

    public void save(SysConfig entity) {
        if (entity.getConfigId() == null) {
            this.sysConfigMapper.insert((Object)entity);
        } else {
            this.sysConfigMapper.updateById((Object)entity);
        }
    }

    public void del(Long configId) {
        this.sysConfigMapper.deleteById(configId);
    }

    public SysConfig findById(Long configId) {
        return (SysConfig)((Object)this.sysConfigMapper.selectById(configId));
    }

    public List<SysConfig> findByType(String configType) {
        return this.sysConfigMapper.findByType(configType);
    }
}

