/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.guochuang.gov.data.base.bean.LoginUser;
import com.guochuang.gov.data.base.security.AuthenticationContextHolder;
import com.guochuang.gov.data.base.security.TokenService;
import com.guochuang.gov.data.common.exception.ServiceException;
import com.guochuang.gov.data.sys.service.SysLoginLogService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    @Resource
    private AuthenticationManager authenticationManager;
    @Autowired
    private SysLoginLogService sysLoginLogService;
    @Autowired
    private TokenService tokenService;
    private Logger logger = LoggerFactory.getLogger(LoginService.class);

    public String login(String username, String password) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationContextHolder.setContext((Authentication)authenticationToken);
        Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
        LoginUser loginUser = (LoginUser)authentication.getPrincipal();
        this.sysLoginLogService.insertLoginLog(loginUser);
        return this.tokenService.createToken(loginUser);
    }

    public String authLogin(String username) {
        String password = "-1";
        Authentication authentication = null;
        try {
            authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        }
        catch (Exception e) {
            this.logger.error("\u767b\u5f55\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
        LoginUser loginUser = (LoginUser)authentication.getPrincipal();
        this.sysLoginLogService.insertLoginLog(loginUser);
        return this.tokenService.createToken(loginUser);
    }
}

