/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.service;

import com.guochuang.gov.data.base.bean.SelectNode;
import com.guochuang.gov.data.base.util.MemCache;
import com.guochuang.gov.data.sys.dao.BaseDataMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="BaseDataService")
public class BaseDataService {
    @Autowired
    private BaseDataMapper baseDataMapper;

    public List<SelectNode> getDicDataList(String dicTypeCode) {
        return this.baseDataMapper.getDicDataList(dicTypeCode);
    }

    public List<SelectNode> getDicTypes() {
        return this.baseDataMapper.getDicTypes();
    }

    public void setDicMap() {
        List<SelectNode> dics = this.baseDataMapper.getAllDicData();
        HashMap<String, ArrayList<SelectNode>> dicMap = new HashMap<String, ArrayList<SelectNode>>();
        for (SelectNode dic : dics) {
            ArrayList<SelectNode> dicList = (ArrayList<SelectNode>)dicMap.get(dic.getGroup());
            if (dicList == null) {
                dicList = new ArrayList<SelectNode>();
            }
            dicList.add(new SelectNode(dic.getValue(), dic.getLabel()));
            dicMap.put(dic.getGroup(), dicList);
        }
        MemCache.setDicMap(dicMap);
    }

    public void setUserMap() {
        HashMap<Long, String> userMap = new HashMap<Long, String>();
        List<SelectNode> list = this.baseDataMapper.getAllUserData();
        for (SelectNode user : list) {
            userMap.put(Long.parseLong(user.getValue()), user.getLabel());
        }
        MemCache.setUserMap(userMap);
    }

    public void setDeptMap() {
        HashMap<String, String> deptMap = new HashMap<String, String>();
        List<SelectNode> list = this.baseDataMapper.getAllDeptData();
        for (SelectNode user : list) {
            deptMap.put(user.getValue(), user.getLabel());
        }
        MemCache.setDeptMap(deptMap);
    }
}

