/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.ext;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.guochuang.gov.data.base.constants.SysConstant;
import com.guochuang.gov.data.base.util.StringConvertUtils;
import com.guochuang.gov.data.common.bean.ResponseMsg;
import com.guochuang.gov.data.common.exception.BusiException;
import com.guochuang.gov.data.common.util.SM2Util;
import com.guochuang.gov.data.common.util.http.HttpClientUtil;
import com.guochuang.gov.data.sys.entity.SysDept;
import com.guochuang.gov.data.sys.entity.SysMenu;
import com.guochuang.gov.data.sys.entity.SysRole;
import com.guochuang.gov.data.sys.entity.SysRoleMenu;
import com.guochuang.gov.data.sys.entity.SysRoleUser;
import com.guochuang.gov.data.sys.entity.SysUser;
import com.guochuang.gov.data.sys.ext.dto.KafkaRoleMenuDto;
import com.guochuang.gov.data.sys.ext.dto.SysDeptDto;
import com.guochuang.gov.data.sys.ext.dto.SysMenuDto;
import com.guochuang.gov.data.sys.ext.dto.SysRoleDto;
import com.guochuang.gov.data.sys.ext.dto.SysRoleMenuDto;
import com.guochuang.gov.data.sys.ext.dto.SysRoleUserDto;
import com.guochuang.gov.data.sys.ext.dto.SysUserDto;
import com.guochuang.gov.data.sys.service.SysDeptService;
import com.guochuang.gov.data.sys.service.SysMenuService;
import com.guochuang.gov.data.sys.service.SysRoleMenuService;
import com.guochuang.gov.data.sys.service.SysRoleService;
import com.guochuang.gov.data.sys.service.SysRoleUserService;
import com.guochuang.gov.data.sys.service.SysUserService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysTransService {
    @Autowired
    private SysDeptService deptService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SysMenuService menuService;
    @Autowired
    private SysRoleService roleService;
    @Autowired
    private SysRoleUserService roleUserService;
    @Autowired
    private SysRoleMenuService roleMenuService;

    public void getAllDept() {
        String url = "/system/dept/all";
        String msg = HttpClientUtil.get((String)(SysConstant.AUTH_URL + url), this.getHeader(), null);
        ResponseMsg responseMsg = (ResponseMsg)JSON.parseObject((String)msg, ResponseMsg.class);
        if (responseMsg.getCode() != 200) {
            throw new BusiException(responseMsg.getMsg());
        }
        Object data = responseMsg.getData();
        List depts = JSON.parseArray((String)JSON.toJSONString((Object)data), SysDeptDto.class);
        List<SysDept> originDepts = this.deptService.findAll();
        ArrayList<SysDept> insertDepts = new ArrayList<SysDept>();
        ArrayList<SysDept> updateDepts = new ArrayList<SysDept>();
        for (SysDeptDto deptDto : depts) {
            if (!this.exist(deptDto, originDepts)) {
                insertDepts.add(this.parseDept(deptDto));
                continue;
            }
            updateDepts.add(this.parseDept(deptDto));
        }
        this.deptService.insert(insertDepts);
        this.deptService.update(updateDepts);
    }

    private SysDept parseDept(SysDeptDto deptDto) {
        SysDept sysDept = new SysDept();
        sysDept.setDeptId(deptDto.getId());
        sysDept.setDeptName(deptDto.getDeptName());
        sysDept.setDeptPid(deptDto.getParentId());
        sysDept.setOrderNum(deptDto.getTreeSort());
        sysDept.setIsUse((byte)(!deptDto.getDelFlag().equals(1) ? 1 : 0));
        return sysDept;
    }

    private boolean exist(SysDeptDto deptDto, List<SysDept> originDepts) {
        for (SysDept dept : originDepts) {
            if (!dept.getDeptId().equals(deptDto.getId())) continue;
            return true;
        }
        return false;
    }

    public void getAllUser() {
        String url = "/system/user/all";
        String msg = HttpClientUtil.get((String)(SysConstant.AUTH_URL + url), this.getHeader(), null);
        ResponseMsg responseMsg = (ResponseMsg)JSON.parseObject((String)msg, ResponseMsg.class);
        if (responseMsg.getCode() != 200) {
            throw new BusiException(responseMsg.getMsg());
        }
        Object data = responseMsg.getData();
        List users = JSON.parseArray((String)JSON.toJSONString((Object)data), SysUserDto.class).stream().filter(s -> StringUtils.hasText((String)s.getWybs())).collect(Collectors.toList());
        List<SysUser> originUsers = this.userService.findAll();
        ArrayList<SysUser> insertUsers = new ArrayList<SysUser>();
        ArrayList<SysUser> updateUsers = new ArrayList<SysUser>();
        for (SysUserDto userDto : users) {
            if (!this.exist(userDto, originUsers)) {
                insertUsers.add(this.parseUser(userDto));
                continue;
            }
            updateUsers.add(this.parseUser(userDto));
        }
        this.userService.insert(insertUsers);
        this.userService.update(updateUsers);
    }

    private Map<String, String> getHeader() {
        String Authorization = SM2Util.encrypt((String)SysConstant.SM2_PUBLIC_KEY, (String)"admin");
        String timestamp = SM2Util.encrypt((String)SysConstant.SM2_PUBLIC_KEY, (String)Long.toString(System.currentTimeMillis()));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", Authorization);
        headers.put("timestamp", timestamp);
        return headers;
    }

    private SysUser parseUser(SysUserDto userDto) {
        SysUser sysUser = new SysUser();
        sysUser.setUserId(Long.valueOf(userDto.getWybs()));
        sysUser.setOaUserId(userDto.getId());
        sysUser.setLoginCode(userDto.getUserName());
        sysUser.setUserName(userDto.getName());
        sysUser.setDeptId(userDto.getDeptId());
        sysUser.setPhoneNo(userDto.getPhoneNumber());
        sysUser.setEmail(userDto.getEmail());
        sysUser.setSex("1".equals(userDto.getSex()) ? "0" : "1");
        sysUser.setIsUse((byte)(!userDto.getDelFlag().equals(1) ? 1 : 0));
        sysUser.setStatus("1");
        return sysUser;
    }

    private boolean exist(SysUserDto userDto, List<SysUser> originUsers) {
        for (SysUser user : originUsers) {
            if (!user.getUserId().equals(Long.valueOf(userDto.getWybs()))) continue;
            return true;
        }
        return false;
    }

    public void getAllRole() {
        String clientId = SysConstant.clientId;
        String url = "/system/role/allRole";
        String msg = HttpClientUtil.get((String)(SysConstant.AUTH_URL + url), this.getHeader(), (Map)MapUtil.of((Object)"clientId", (Object)clientId));
        ResponseMsg responseMsg = (ResponseMsg)JSON.parseObject((String)msg, ResponseMsg.class);
        if (responseMsg.getCode() != 200) {
            throw new BusiException(responseMsg.getMsg());
        }
        Object data = responseMsg.getData();
        List roles = JSON.parseArray((String)JSON.toJSONString((Object)data), SysRoleDto.class);
        List<SysRole> originRoles = this.roleService.list();
        ArrayList<SysRole> insertRoles = new ArrayList<SysRole>();
        ArrayList<SysRole> updateRoles = new ArrayList<SysRole>();
        for (SysRoleDto roleDto : roles) {
            if (!this.exist(roleDto, originRoles)) {
                insertRoles.add(this.parseRole(roleDto));
                continue;
            }
            updateRoles.add(this.parseRole(roleDto));
        }
        this.roleService.insert(insertRoles);
        this.roleService.update(updateRoles);
    }

    private SysRole parseRole(SysRoleDto roleDto) {
        SysRole sysRole = new SysRole();
        sysRole.setRoleId(StringConvertUtils.stringToLong((String)roleDto.getId()));
        sysRole.setRoleName(roleDto.getRoleName());
        sysRole.setRoleCode(roleDto.getRoleKey());
        sysRole.setMemo(roleDto.getRemark());
        sysRole.setIsUse((byte)(!"1".equals(roleDto.getDelFlag()) ? 1 : 0));
        return sysRole;
    }

    private boolean exist(SysRoleDto roleDto, List<SysRole> originRoles) {
        for (SysRole role : originRoles) {
            if (!role.getRoleId().equals(StringConvertUtils.stringToLong((String)roleDto.getId()))) continue;
            return true;
        }
        return false;
    }

    public void getAllMenu() {
        String clientId = SysConstant.clientId;
        String url = "/system/menu/all";
        String msg = HttpClientUtil.get((String)(SysConstant.AUTH_URL + url), this.getHeader(), (Map)MapUtil.of((Object)"clientId", (Object)clientId));
        ResponseMsg responseMsg = (ResponseMsg)JSON.parseObject((String)msg, ResponseMsg.class);
        if (responseMsg.getCode() != 200) {
            throw new BusiException(responseMsg.getMsg());
        }
        Object data = responseMsg.getData();
        List menus = JSON.parseArray((String)JSON.toJSONString((Object)data), SysMenuDto.class);
        List<SysMenu> originMenus = this.menuService.list();
        ArrayList<SysMenu> insertMenus = new ArrayList<SysMenu>();
        ArrayList<SysMenu> updateMenus = new ArrayList<SysMenu>();
        for (SysMenuDto menuDto : menus) {
            if (!this.exist(menuDto, originMenus)) {
                insertMenus.add(this.parseMenu(menuDto));
                continue;
            }
            updateMenus.add(this.parseMenu(menuDto));
        }
        this.menuService.insert(insertMenus);
        this.menuService.update(updateMenus);
    }

    private boolean exist(SysMenuDto menuDto, List<SysMenu> originMenus) {
        for (SysMenu menu : originMenus) {
            if (!menu.getMenuId().equals(StringConvertUtils.stringToLong((String)menuDto.getId()))) continue;
            return true;
        }
        return false;
    }

    private SysMenu parseMenu(SysMenuDto menuDto) {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setMenuId(StringConvertUtils.stringToLong((String)menuDto.getId()));
        sysMenu.setMenuPid(StringConvertUtils.stringToLong((String)menuDto.getParentId()));
        sysMenu.setMenuName(menuDto.getMenuName());
        sysMenu.setRoute(menuDto.getPath());
        sysMenu.setMenuUrl(menuDto.getComponent());
        if ("C".equals(menuDto.getMenuType())) {
            sysMenu.setIsFile("1");
        } else if ("M".equals(menuDto.getMenuType())) {
            sysMenu.setIsFile("0");
            sysMenu.setMenuUrl("Layout");
        }
        sysMenu.setIsShow("0".equals(menuDto.getVisible()) ? "1" : "0");
        sysMenu.setIcon(menuDto.getIcon());
        sysMenu.setMemo(menuDto.getRemark());
        sysMenu.setOrderNum(menuDto.getTreeSort());
        sysMenu.setIsUse((byte)(!"1".equals(menuDto.getDelFlag()) ? 1 : 0));
        return sysMenu;
    }

    public void getAllRoleUser() {
        String clientId = SysConstant.clientId;
        String url = "/system/user/allUserRole";
        String msg = HttpClientUtil.get((String)(SysConstant.AUTH_URL + url), this.getHeader(), (Map)MapUtil.of((Object)"clientId", (Object)clientId));
        ResponseMsg responseMsg = (ResponseMsg)JSON.parseObject((String)msg, ResponseMsg.class);
        if (responseMsg.getCode() != 200) {
            throw new BusiException(responseMsg.getMsg());
        }
        Object data = responseMsg.getData();
        List roles = JSON.parseArray((String)JSON.toJSONString((Object)data), SysRoleUserDto.class);
        List<SysRole> roleList = this.roleService.list();
        List roleIds = roleList.stream().map(SysRole::getRoleId).collect(Collectors.toList());
        List<SysRoleUser> roleUserList = roles.stream().map(this::parseRoleUser).filter(r -> roleIds.contains(r.getRoleId())).collect(Collectors.toList());
        this.roleUserService.deleteAll();
        this.roleUserService.insert(roleUserList);
    }

    private SysRoleUser parseRoleUser(SysRoleUserDto sysRoleUserDto) {
        SysRoleUser sysRoleUser = new SysRoleUser();
        sysRoleUser.setRoleId(StringConvertUtils.stringToLong((String)sysRoleUserDto.getRoleId()));
        String oaUserId = sysRoleUserDto.getUserId();
        SysUser sysUser = this.userService.findByOaUserId(oaUserId);
        Optional.ofNullable(sysUser).ifPresent(s -> sysRoleUser.setUserId(s.getUserId()));
        return sysRoleUser;
    }

    public void getAllRoleMenu() {
        String clientId = SysConstant.clientId;
        String url = "/system/role/allRoleMenu";
        String msg = HttpClientUtil.get((String)(SysConstant.AUTH_URL + url), this.getHeader(), (Map)MapUtil.of((Object)"clientId", (Object)clientId));
        ResponseMsg responseMsg = (ResponseMsg)JSON.parseObject((String)msg, ResponseMsg.class);
        if (responseMsg.getCode() != 200) {
            throw new BusiException(responseMsg.getMsg());
        }
        Object data = responseMsg.getData();
        List roleMenuDtos = JSON.parseArray((String)JSON.toJSONString((Object)data), SysRoleMenuDto.class);
        List<SysRole> roleList = this.roleService.list();
        List<SysMenu> menuList = this.menuService.list();
        List roleIds = roleList.stream().map(SysRole::getRoleId).collect(Collectors.toList());
        List menuIds = menuList.stream().map(SysMenu::getMenuId).collect(Collectors.toList());
        List<SysRoleMenu> roleMenuList = roleMenuDtos.stream().map(this::parseRoleMenu).filter(r -> roleIds.contains(r.getRoleId()) && menuIds.contains(r.getMenuId())).collect(Collectors.toList());
        this.roleMenuService.deleteAll();
        this.roleMenuService.insert(roleMenuList);
    }

    private SysRoleMenu parseRoleMenu(SysRoleMenuDto sysRoleMenuDto) {
        SysRoleMenu sysRoleMenu = new SysRoleMenu();
        sysRoleMenu.setRoleId(StringConvertUtils.stringToLong((String)sysRoleMenuDto.getRoleId()));
        sysRoleMenu.setMenuId(StringConvertUtils.stringToLong((String)sysRoleMenuDto.getMenuId()));
        return sysRoleMenu;
    }

    public void addUser(String message) {
        SysUserDto sysUserDto = (SysUserDto)JSON.parseObject((String)message, SysUserDto.class);
        SysUser sysUser = this.parseUser(sysUserDto);
        this.userService.insert(sysUser);
        List<String> roleIds = sysUserDto.getRoleIds();
        List<SysRoleUser> roleUsers = roleIds.stream().map(r -> {
            SysRoleUser sysRoleUser = new SysRoleUser();
            sysRoleUser.setUserId(sysUser.getUserId());
            sysRoleUser.setRoleId(StringConvertUtils.stringToLong((String)r));
            return sysRoleUser;
        }).collect(Collectors.toList());
        this.roleUserService.insert(roleUsers);
    }

    public void updateUser(String message) {
        SysUserDto sysUserDto = (SysUserDto)JSON.parseObject((String)message, SysUserDto.class);
        SysUser sysUser = this.parseUser(sysUserDto);
        this.userService.update(sysUser);
        List<String> roleIds = sysUserDto.getRoleIds();
        List<SysRoleUser> roleUsers = roleIds.stream().map(r -> {
            SysRoleUser sysRoleUser = new SysRoleUser();
            sysRoleUser.setUserId(sysUser.getUserId());
            sysRoleUser.setRoleId(StringConvertUtils.stringToLong((String)r));
            return sysRoleUser;
        }).collect(Collectors.toList());
        this.roleUserService.deleteByUserId(sysUser.getUserId());
        this.roleUserService.insert(roleUsers);
    }

    public void deleteUser(String message) {
        SysUserDto sysUserDto = (SysUserDto)JSON.parseObject((String)message, SysUserDto.class);
        Long userId = StringConvertUtils.stringToLong((String)sysUserDto.getId());
        this.userService.del(userId);
        this.roleUserService.deleteByUserId(userId);
    }

    public void addDept(String message) {
        SysDeptDto sysDeptDto = (SysDeptDto)JSON.parseObject((String)message, SysDeptDto.class);
        this.deptService.insert(this.parseDept(sysDeptDto));
    }

    public void updateDept(String message) {
        SysDeptDto sysDeptDto = (SysDeptDto)JSON.parseObject((String)message, SysDeptDto.class);
        this.deptService.update(this.parseDept(sysDeptDto));
    }

    public void deleteDept(String message) {
        SysDeptDto sysDeptDto = (SysDeptDto)JSON.parseObject((String)message, SysDeptDto.class);
        this.deptService.del(StringConvertUtils.stringToLong((String)sysDeptDto.getId()));
    }

    public void addMenu(String message) {
        String clientId = SysConstant.clientId;
        SysMenuDto sysMenuDto = (SysMenuDto)JSON.parseObject((String)message, SysMenuDto.class);
        if (clientId.equals(sysMenuDto.getClientId())) {
            this.menuService.insert(this.parseMenu(sysMenuDto));
        }
    }

    public void updateMenu(String message) {
        String clientId = SysConstant.clientId;
        SysMenuDto sysMenuDto = (SysMenuDto)JSON.parseObject((String)message, SysMenuDto.class);
        if (clientId.equals(sysMenuDto.getClientId())) {
            this.menuService.update(this.parseMenu(sysMenuDto));
        }
    }

    public void deleteMenu(String message) {
        String clientId = SysConstant.clientId;
        SysMenuDto sysMenuDto = (SysMenuDto)JSON.parseObject((String)message, SysMenuDto.class);
        if (clientId.equals(sysMenuDto.getClientId())) {
            Long menuId = StringConvertUtils.stringToLong((String)sysMenuDto.getId());
            this.menuService.del(menuId);
            this.roleMenuService.deleteByMenuId(menuId);
        }
    }

    public void addRole(String message) {
        SysRoleDto sysRoleDto = (SysRoleDto)JSON.parseObject((String)message, SysRoleDto.class);
        String clientId = SysConstant.clientId;
        if (StringUtils.hasText((String)sysRoleDto.getClientIds()) && sysRoleDto.getClientIds().contains(clientId)) {
            this.roleService.insert(this.parseRole(sysRoleDto));
        }
    }

    public void updateRole(String message) {
        SysRoleDto sysRoleDto = (SysRoleDto)JSON.parseObject((String)message, SysRoleDto.class);
        String clientId = SysConstant.clientId;
        if (StringUtils.hasText((String)sysRoleDto.getClientIds()) && sysRoleDto.getClientIds().contains(clientId)) {
            SysRole sysRole = this.parseRole(sysRoleDto);
            Long roleId = sysRole.getRoleId();
            SysRole oldRole = this.roleService.findById(roleId);
            if (oldRole != null) {
                this.roleService.update(sysRole);
            } else {
                this.roleService.insert(sysRole);
            }
        }
    }

    public void deleteRole(String message) {
        SysRoleDto sysRoleDto = (SysRoleDto)JSON.parseObject((String)message, SysRoleDto.class);
        String clientId = SysConstant.clientId;
        if (StringUtils.hasText((String)sysRoleDto.getClientIds()) && sysRoleDto.getClientIds().contains(clientId)) {
            this.roleService.del(StringConvertUtils.stringToLong((String)sysRoleDto.getId()));
        }
    }

    public void addRoleUser(String message) {
        SysRoleUserDto sysRoleUserDto = (SysRoleUserDto)JSON.parseObject((String)message, SysRoleUserDto.class);
        this.roleUserService.insert(this.parseRoleUser(sysRoleUserDto));
    }

    public void deleteRoleUser(String message) {
        SysRoleUserDto sysRoleUserDto = (SysRoleUserDto)JSON.parseObject((String)message, SysRoleUserDto.class);
        Long roleId = StringConvertUtils.stringToLong((String)sysRoleUserDto.getRoleId());
        List<String> userIds = sysRoleUserDto.getUserIds();
        List unSelUserIds = userIds.stream().map(StringConvertUtils::stringToLong).collect(Collectors.toList());
        String ids = Joiner.on((String)",").join(unSelUserIds);
        this.roleUserService.unSelUser(roleId, ids);
    }

    public void addRoleMenu(String message) {
        KafkaRoleMenuDto kafkaRoleMenuDto = (KafkaRoleMenuDto)JSON.parseObject((String)message, KafkaRoleMenuDto.class);
        this.roleMenuService.insert(this.parseRoleMenu(kafkaRoleMenuDto));
    }

    private List<SysRoleMenu> parseRoleMenu(KafkaRoleMenuDto kafkaRoleMenuDto) {
        Long roleId = StringConvertUtils.stringToLong((String)kafkaRoleMenuDto.getId());
        return kafkaRoleMenuDto.getMenuIds().stream().map(m -> {
            SysRoleMenu sysRoleMenu = new SysRoleMenu();
            sysRoleMenu.setRoleId(roleId);
            sysRoleMenu.setMenuId(StringConvertUtils.stringToLong((String)m));
            return sysRoleMenu;
        }).collect(Collectors.toList());
    }

    public void deleteRoleMenu(String message) {
        KafkaRoleMenuDto kafkaRoleMenuDto = (KafkaRoleMenuDto)JSON.parseObject((String)message, KafkaRoleMenuDto.class);
        Long roleId = StringConvertUtils.stringToLong((String)kafkaRoleMenuDto.getId());
        List<String> menuIds = kafkaRoleMenuDto.getMenuIds();
        List unSelMenuIds = menuIds.stream().map(StringConvertUtils::stringToLong).collect(Collectors.toList());
        String ids = Joiner.on((String)",").join(unSelMenuIds);
        this.roleMenuService.unSelMenu(roleId, ids);
    }
}

