/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.ext;

import com.guochuang.gov.data.sys.ext.SysTransService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.TopicPartition;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"})
public class KafkaConsumer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumer.class);
    @Autowired
    private SysTransService sysTransService;

    @KafkaListener(topicPartitions={@TopicPartition(topic="portalMsg", partitions={"0"})})
    public void handleWithUserMessage(@Payload String message, @Header(value="kafka_receivedPartitionId") int partition, @Header(value="kafka_receivedMessageKey") String key) {
        logger.info("Received message: " + message + " from partition " + partition + " with key " + key);
        switch (key) {
            case "00010": {
                this.sysTransService.addUser(message);
                break;
            }
            case "00011": {
                this.sysTransService.updateUser(message);
                break;
            }
            case "00012": {
                this.sysTransService.deleteUser(message);
                break;
            }
        }
    }

    @KafkaListener(topicPartitions={@TopicPartition(topic="portalMsg", partitions={"1"})})
    public void handleWithDeptMessage(@Payload String message, @Header(value="kafka_receivedPartitionId") int partition, @Header(value="kafka_receivedMessageKey") String key) {
        logger.info("Received message: " + message + " from partition " + partition + " with key " + key);
        switch (key) {
            case "00020": {
                this.sysTransService.addDept(message);
                break;
            }
            case "00021": {
                this.sysTransService.updateDept(message);
                break;
            }
            case "00022": {
                this.sysTransService.deleteDept(message);
                break;
            }
        }
    }

    @KafkaListener(topicPartitions={@TopicPartition(topic="portalMsg", partitions={"2"})})
    public void handleWithRoleMessage(@Payload String message, @Header(value="kafka_receivedPartitionId") int partition, @Header(value="kafka_receivedMessageKey") String key) {
        logger.info("Received message: " + message + " from partition " + partition + " with key " + key);
        switch (key) {
            case "00030": {
                this.sysTransService.addRole(message);
                break;
            }
            case "00031": {
                this.sysTransService.updateRole(message);
                break;
            }
            case "00032": {
                this.sysTransService.deleteRole(message);
                break;
            }
            case "00033": {
                this.sysTransService.addRoleUser(message);
                break;
            }
            case "00034": {
                this.sysTransService.deleteRoleUser(message);
                break;
            }
            case "00035": {
                this.sysTransService.addRoleMenu(message);
                break;
            }
            case "00036": {
                this.sysTransService.deleteRoleMenu(message);
                break;
            }
        }
    }

    @KafkaListener(topicPartitions={@TopicPartition(topic="portalMsg", partitions={"3"})})
    public void handleWithMenuMessage(@Payload String message, @Header(value="kafka_receivedPartitionId") int partition, @Header(value="kafka_receivedMessageKey") String key) {
        logger.info("Received message: " + message + " from partition " + partition + " with key " + key);
        switch (key) {
            case "00040": {
                this.sysTransService.addMenu(message);
                break;
            }
            case "00041": {
                this.sysTransService.updateMenu(message);
                break;
            }
            case "00042": {
                this.sysTransService.deleteMenu(message);
                break;
            }
        }
    }
}

