/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.controller;

import com.guochuang.gov.data.base.util.SysUtil;
import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.bean.ResponseMsg;
import com.guochuang.gov.data.sys.entity.SysUser;
import com.guochuang.gov.data.sys.service.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysUser"})
public class SysUserController {
    @Autowired
    private SysUserService sysUserService;

    @GetMapping(value={"/query"})
    public PageObject query(String fuzzy, int pageNum, int pageSize) {
        PageObject pageObject = this.sysUserService.query(fuzzy, pageNum, pageSize);
        return pageObject;
    }

    @PostMapping(value={"/save"})
    public ResponseMsg save(@RequestBody SysUser entity) {
        this.sysUserService.save(entity);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/del"})
    public ResponseMsg del(Long userId) {
        this.sysUserService.del(userId);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/findById"})
    public ResponseMsg findById(Long userId) {
        SysUser entity = this.sysUserService.findById(userId);
        return ResponseMsg.getSuccessMsg((Object)((Object)entity));
    }

    @GetMapping(value={"/resetPwd"})
    public ResponseMsg resetPwd(Long userId) {
        this.sysUserService.resetPwd(userId);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/editPwd"})
    public ResponseMsg editPwd(String oldPwd, String newPwd) {
        this.sysUserService.editPwd(oldPwd, newPwd);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/getUserProfile"})
    public ResponseMsg getUserProfile() {
        SysUser entity = this.sysUserService.findById(SysUtil.getUserId());
        return ResponseMsg.getSuccessMsg((Object)((Object)entity));
    }
}

