/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.controller;

import com.guochuang.gov.data.base.bean.TreeNode;
import com.guochuang.gov.data.common.bean.ResponseMsg;
import com.guochuang.gov.data.sys.entity.SysMenu;
import com.guochuang.gov.data.sys.service.SysMenuService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysMenu"})
public class SysMenuController {
    @Autowired
    private SysMenuService sysMenuService;

    @GetMapping(value={"/getMenuTree"})
    public List<TreeNode> getMenuTree() {
        return this.sysMenuService.getMenuTree();
    }

    @PostMapping(value={"/save"})
    public ResponseMsg save(@RequestBody SysMenu entity) {
        this.sysMenuService.save(entity);
        return ResponseMsg.getSuccessMsg((Object)((Object)entity));
    }

    @GetMapping(value={"/del"})
    public ResponseMsg del(Long menuId) {
        this.sysMenuService.del(menuId);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/findById"})
    public ResponseMsg findById(Long menuId) {
        SysMenu entity = this.sysMenuService.findById(menuId);
        return ResponseMsg.getSuccessMsg((Object)((Object)entity));
    }

    @PostMapping(value={"/saveCurrentDirs"})
    public ResponseMsg saveCurrentDirs(@RequestBody String data) {
        this.sysMenuService.saveCurrentDirs(data);
        return ResponseMsg.getSuccessMsg();
    }
}

