/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.controller;

import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.bean.ResponseMsg;
import com.guochuang.gov.data.sys.entity.SysConfig;
import com.guochuang.gov.data.sys.service.SysConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysConfig"})
public class SysConfigController {
    @Autowired
    private SysConfigService sysConfigService;

    @GetMapping(value={"/query"})
    public PageObject query(String fuzzy, String configType, int pageNum, int pageSize) {
        PageObject pageObject = this.sysConfigService.query(fuzzy, configType, pageNum, pageSize);
        return pageObject;
    }

    @GetMapping(value={"/findByType"})
    public List<SysConfig> findByType(String configType) {
        return this.sysConfigService.findByType(configType);
    }

    @PostMapping(value={"/save"})
    public ResponseMsg save(@RequestBody SysConfig entity) {
        this.sysConfigService.save(entity);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/del"})
    public ResponseMsg del(Long configId) {
        this.sysConfigService.del(configId);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/findById"})
    public ResponseMsg findById(Long configId) {
        SysConfig entity = this.sysConfigService.findById(configId);
        return ResponseMsg.getSuccessMsg((Object)((Object)entity));
    }
}

