/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.controller;

import com.guochuang.gov.data.common.bean.PageObject;
import com.guochuang.gov.data.common.bean.ResponseMsg;
import com.guochuang.gov.data.sys.dto.SysApiDto;
import com.guochuang.gov.data.sys.entity.SysApi;
import com.guochuang.gov.data.sys.service.SysApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysApi"})
public class SysApiController {
    @Autowired
    private SysApiService sysApiService;

    @GetMapping(value={"/query"})
    public PageObject query(int pageNum, int pageSize) {
        PageObject pageObject = this.sysApiService.query(pageNum, pageSize);
        return pageObject;
    }

    @PostMapping(value={"/save"})
    public ResponseMsg save(@RequestBody SysApi entity) {
        this.sysApiService.save(entity);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/del"})
    public ResponseMsg del(Long apiId) {
        this.sysApiService.del(apiId);
        return ResponseMsg.getSuccessMsg();
    }

    @GetMapping(value={"/findById"})
    public ResponseMsg findById(Long apiId) {
        SysApi entity = this.sysApiService.findById(apiId);
        return ResponseMsg.getSuccessMsg((Object)((Object)entity));
    }

    @GetMapping(value={"/findByApiCode"})
    public ResponseMsg findByApiCode(String apiCode) {
        SysApiDto sysApiDto = this.sysApiService.findByApiCode(apiCode);
        return ResponseMsg.getSuccessMsg((Object)sysApiDto);
    }
}

