/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.gov.data.sys.controller;

import com.guochuang.gov.data.base.bean.LoginUser;
import com.guochuang.gov.data.base.util.SysUtil;
import com.guochuang.gov.data.common.bean.ResponseMsg;
import com.guochuang.gov.data.sys.dto.LoginUserDto;
import com.guochuang.gov.data.sys.service.LoginService;
import com.guochuang.gov.data.sys.service.SysRoleMenuService;
import com.guochuang.gov.data.sys.service.SysRoleUserService;
import com.guochuang.gov.data.sys.vo.LoginUserVo;
import com.guochuang.gov.data.sys.vo.RouterVo;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    @Autowired
    private LoginService loginService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysRoleUserService sysRoleUserService;
    private Logger logger = LoggerFactory.getLogger(LoginController.class);

    @PostMapping(value={"/login"})
    public ResponseMsg login(@RequestBody LoginUserVo loginUserVo) {
        return ResponseMsg.getSuccessMsg((Object)this.loginService.login(loginUserVo.getUsername(), loginUserVo.getPassword()));
    }

    @GetMapping(value={"/authLogin"})
    public ResponseMsg authLogin(String userName) {
        return ResponseMsg.getSuccessMsg((Object)this.loginService.authLogin(userName));
    }

    @GetMapping(value={"/getInfo"})
    public ResponseMsg getInfo() {
        LoginUser loginUser = SysUtil.getLoginUser();
        LoginUserDto dto = new LoginUserDto();
        dto.setUserId(loginUser.getUserId());
        dto.setUserName(loginUser.getUserName());
        dto.setLoginCode(loginUser.getLoginCode());
        dto.setRoleId(loginUser.getRoleId());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("user", dto);
        data.put("roles", this.sysRoleUserService.getUserRoles(loginUser.getUserId()));
        return ResponseMsg.getSuccessMsg(data);
    }

    @GetMapping(value={"/getRouters"})
    public ResponseMsg getRouters(HttpServletRequest request) {
        Long userId = SysUtil.getUserId();
        List<RouterVo> list = this.sysRoleMenuService.getUserMenus(userId);
        return ResponseMsg.getSuccessMsg(list);
    }
}

