/*
 * Decompiled with CFR 0.152.
 */
package proguard.io.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.function.BiFunction;
import proguard.classfile.ClassPool;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.ClassPath;
import proguard.io.ClassPathEntry;
import proguard.io.ClassReader;
import proguard.io.DataEntry;
import proguard.io.DataEntryClassWriter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryReaderFactory;
import proguard.io.DataEntryWriter;
import proguard.io.DirectorySource;
import proguard.io.FixedFileWriter;
import proguard.io.JarWriter;
import proguard.io.NameFilteredDataEntryReader;
import proguard.io.ZipWriter;

public class IOUtil {
    private IOUtil() {
    }

    public static ClassPool read(String fileName, boolean isLibrary) throws IOException {
        return IOUtil.read(new File(fileName), isLibrary);
    }

    public static ClassPool read(String fileName, boolean isLibrary, boolean initializeKotlinMetadata) throws IOException {
        return IOUtil.read(new File(fileName), isLibrary, initializeKotlinMetadata);
    }

    public static ClassPool read(File file, boolean isLibrary) throws IOException {
        return IOUtil.read(file, isLibrary, false);
    }

    public static ClassPool read(File file, boolean isLibrary, boolean initializeKotlinMetadata) throws IOException {
        return IOUtil.read(file, isLibrary, initializeKotlinMetadata, (dataEntryReader, classPool) -> dataEntryReader);
    }

    public static ClassPool read(File file, boolean isLibrary, boolean initializeKotlinMetadata, BiFunction<DataEntryReader, ClassVisitor, DataEntryReader> extraDataEntryReader) throws IOException {
        return IOUtil.read(new ClassPath(new ClassPathEntry(file, false)), "**", false, isLibrary, initializeKotlinMetadata, false, false, false, extraDataEntryReader);
    }

    public static ClassPool read(ClassPath classPath, String classNameFilter, boolean android, boolean isLibrary, boolean skipNonPublicLibraryClasses, boolean skipNonPublicLibraryClassMembers, boolean ignoreStackMapAttributes, BiFunction<DataEntryReader, ClassVisitor, DataEntryReader> extraDataEntryReader) throws IOException {
        return IOUtil.read(classPath, classNameFilter, android, isLibrary, false, skipNonPublicLibraryClasses, skipNonPublicLibraryClassMembers, ignoreStackMapAttributes, extraDataEntryReader);
    }

    public static ClassPool read(ClassPath classPath, String classNameFilter, boolean android, boolean isLibrary, boolean initializeKotlinMetadata, boolean skipNonPublicLibraryClasses, boolean skipNonPublicLibraryClassMembers, boolean ignoreStackMapAttributes, BiFunction<DataEntryReader, ClassVisitor, DataEntryReader> extraDataEntryReader) throws IOException {
        WarningPrinter nullWarningPrinter = new WarningPrinter(new PrintWriter(new OutputStream(){

            @Override
            public void write(int i) {
            }
        }));
        ClassPool classPool = new ClassPool();
        ClassVisitor classPoolFiller = new ClassPoolFiller(classPool);
        if (classNameFilter != null) {
            classPoolFiller = new ClassNameFilter(classNameFilter, classPoolFiller);
        }
        DataEntryReader classReader = new NameFilteredDataEntryReader("**.class", (DataEntryReader)new ClassReader(isLibrary, skipNonPublicLibraryClasses, skipNonPublicLibraryClassMembers, ignoreStackMapAttributes, initializeKotlinMetadata, nullWarningPrinter, classPoolFiller));
        classReader = extraDataEntryReader.apply(classReader, classPoolFiller);
        for (int index = 0; index < classPath.size(); ++index) {
            ClassPathEntry entry = classPath.get(index);
            if (entry.isOutput()) continue;
            try {
                DataEntryReader reader = new DataEntryReaderFactory(android).createDataEntryReader(entry, classReader);
                DirectorySource source = new DirectorySource(entry.getFile());
                source.pumpDataEntries(reader);
                continue;
            }
            catch (IOException ex) {
                throw new IOException("Can't read [" + entry + "] (" + ex.getMessage() + ")", ex);
            }
        }
        return classPool;
    }

    public static void writeJar(ClassPool programClassPool, String outputJarFileName) throws IOException {
        IOUtil.writeJar(programClassPool, outputJarFileName, null);
    }

    public static void writeJar(ClassPool programClassPool, String outputJarFileName, String mainClassName) throws IOException {
        class MyJarWriter
        extends JarWriter
        implements Closeable {
            final /* synthetic */ String val$mainClassName;

            public MyJarWriter(DataEntryWriter dataEntryWriter) {
                this.val$mainClassName = dataEntryWriter;
                super(zipEntryWriter);
            }

            @Override
            protected OutputStream createManifestOutputStream(DataEntry manifestEntry) throws IOException {
                OutputStream outputStream = super.createManifestOutputStream(manifestEntry);
                if (this.val$mainClassName != null) {
                    PrintWriter writer = new PrintWriter(outputStream);
                    writer.println("Main-Class: " + this.val$mainClassName);
                    writer.flush();
                }
                return outputStream;
            }

            @Override
            public void close() throws IOException {
                super.close();
            }
        }
        try (MyJarWriter jarWriter = new MyJarWriter((DataEntryWriter)new ZipWriter(new FixedFileWriter(new File(outputJarFileName))), mainClassName);){
            programClassPool.classesAccept(new DataEntryClassWriter(jarWriter));
        }
    }
}

