/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionOpCodeFilter;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class OpcodeOffsetFinder
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor {
    private final int[] targetOpcodes;
    private final List<Integer> foundOffsets = new ArrayList<Integer>();

    public OpcodeOffsetFinder(int[] targetOpcodes) {
        this.targetOpcodes = targetOpcodes;
    }

    public List<Integer> getFoundOffsets() {
        return this.foundOffsets;
    }

    public void reset() {
        this.foundOffsets.clear();
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.accept(clazz, method, (AttributeVisitor)new AllInstructionVisitor(new InstructionOpCodeFilter(this.targetOpcodes, this)));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.foundOffsets.add(offset);
    }
}

