/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.bam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import proguard.analysis.cpa.algorithms.CpaAlgorithm;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.defaults.BreadthFirstWaitlist;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.StopSepOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.ProgramLocationDependentTransferRelation;
import proguard.analysis.cpa.interfaces.StopOperator;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.interfaces.Waitlist;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;

public class BamTransferRelation<ContentT extends AbstractState<ContentT>>
implements TransferRelation<JvmAbstractState<ContentT>> {
    private final BamCpa<ContentT> bamCpa;
    private final JvmCfa cfa;
    private final Stack<StackEntry> stack = new Stack();
    private final JvmCfaNode mainLocation;
    private final BamCache<ContentT> cache;
    private final int maxCallStackDepth;
    private final StopOperator<JvmAbstractState<ContentT>> fixedPointStopOperator;
    private boolean fixedPointReached = false;

    public BamTransferRelation(BamCpa<ContentT> bamCpa, JvmCfa cfa, MethodSignature mainFunction, BamCache<ContentT> cache) {
        this(bamCpa, cfa, mainFunction, cache, -1);
    }

    public BamTransferRelation(BamCpa<ContentT> bamCpa, JvmCfa cfa, MethodSignature mainFunction, BamCache<ContentT> cache, int maxCallStackDepth) {
        this.bamCpa = bamCpa;
        this.cfa = cfa;
        this.mainLocation = (JvmCfaNode)cfa.getFunctionEntryNode(mainFunction);
        this.cache = cache;
        this.fixedPointStopOperator = new StopSepOperator<JvmAbstractState<ContentT>>();
        this.maxCallStackDepth = maxCallStackDepth;
    }

    @Override
    public Collection<JvmAbstractState<ContentT>> generateAbstractSuccessors(JvmAbstractState<ContentT> abstractState, Precision precision) {
        JvmCfaNode currentLocation = abstractState.getProgramLocation();
        ArrayList<JvmAbstractState<ContentT>> abstractSuccessors = new ArrayList<JvmAbstractState<ContentT>>();
        if (this.stack.isEmpty() && currentLocation.equals(this.mainLocation)) {
            abstractSuccessors.addAll(this.fixedPoint(abstractState, precision));
        } else if (currentLocation.getLeavingEdges().stream().anyMatch(JvmCallCfaEdge.class::isInstance)) {
            for (JvmCfaEdge callEdge : currentLocation.getLeavingEdges().stream().filter(JvmCallCfaEdge.class::isInstance).collect(Collectors.toList())) {
                if (!(this.maxCallStackDepth >= 0 && this.stack.size() >= this.maxCallStackDepth || callEdge.getTarget().isUnknownNode())) {
                    abstractSuccessors.addAll(this.applyBlockAbstraction(abstractState, precision, (JvmCallCfaEdge)callEdge));
                    continue;
                }
                abstractSuccessors.addAll(((ProgramLocationDependentTransferRelation)this.bamCpa.getIntraproceduralTransferRelation()).generateEdgeAbstractSuccessors(abstractState, callEdge, precision));
            }
        } else {
            abstractSuccessors.addAll(this.bamCpa.getIntraproceduralTransferRelation().generateAbstractSuccessors(abstractState, precision));
        }
        return abstractSuccessors;
    }

    protected Waitlist<JvmAbstractState<ContentT>> getWaitlist() {
        return new BreadthFirstWaitlist<JvmAbstractState<ContentT>>();
    }

    protected ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> getReachedSet() {
        return new ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>>();
    }

    public BamCache<ContentT> getCache() {
        return this.cache;
    }

    public JvmCfa getCfa() {
        return this.cfa;
    }

    private Collection<JvmAbstractState<ContentT>> fixedPoint(JvmAbstractState<ContentT> entryState, Precision precision) {
        Collection<JvmAbstractState<ContentT>> blockResult = Collections.emptyList();
        while (!this.fixedPointReached) {
            this.fixedPointReached = true;
            blockResult = this.applyBlockAbstraction(entryState, precision, null);
        }
        return blockResult;
    }

    private Collection<JvmAbstractState<ContentT>> applyBlockAbstraction(JvmAbstractState<ContentT> callState, Precision precision, JvmCallCfaEdge callEdge) {
        BlockAbstraction<ContentT> cacheEntry;
        ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reached = this.getReachedSet();
        Waitlist<JvmAbstractState<ContentT>> waitlist = this.getWaitlist();
        Call call = callEdge == null ? null : callEdge.getCall();
        JvmCfaNode entryNode = call != null ? (JvmCfaNode)this.cfa.getFunctionEntryNode(callEdge.getTarget().getSignature()) : callState.getProgramLocation();
        MethodSignature currentFunction = entryNode.getSignature();
        JvmAbstractState reducedEntryState = call != null ? this.bamCpa.getReduceOperator().reduce(callState, (JvmCfaNode)this.cfa.getFunctionEntryNode(currentFunction), call) : this.bamCpa.getReduceOperator().onMethodEntry(callState, this.isCallStatic(callState));
        Optional<JvmAbstractState> previousCall = this.stack.stream().filter(x -> x.function.equals(currentFunction) && reducedEntryState.isLessOrEqual(x.entryState)).map(x -> x.entryState).findFirst();
        if (previousCall.isPresent()) {
            cacheEntry = this.cache.get(previousCall.get(), precision, currentFunction);
            if (cacheEntry != null) {
                reached = cacheEntry.getReachedSet();
            } else {
                this.stack.peek().incompleteCallStates.add(callState);
                this.fixedPointReached = false;
            }
        } else {
            cacheEntry = this.cache.get(reducedEntryState, precision, currentFunction);
            if (cacheEntry != null) {
                reached = cacheEntry.getReachedSet();
                waitlist = cacheEntry.getWaitlist();
            } else {
                reached.add(reducedEntryState);
                waitlist.add(reducedEntryState);
            }
            this.stack.push(new StackEntry(currentFunction, reducedEntryState));
            new CpaAlgorithm<ContentT>(this.bamCpa).run(reached, waitlist);
            StackEntry stackEntry = this.stack.pop();
            if (!stackEntry.incompleteCallStates.isEmpty()) {
                if (!this.stack.isEmpty()) {
                    this.stack.peek().incompleteCallStates.add(callState);
                }
                for (JvmAbstractState incompleteCallState : stackEntry.incompleteCallStates) {
                    waitlist.add(incompleteCallState);
                }
            }
            if ((cacheEntry = this.cache.get(reducedEntryState, precision, currentFunction)) != null) {
                ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reachedOld = cacheEntry.getReachedSet();
                for (JvmAbstractState<ContentT> exitState : this.getExitStates(reached, this.cfa, currentFunction)) {
                    Collection<JvmAbstractState<ContentT>> oldExitStates;
                    if (this.fixedPointStopOperator.stop(exitState, oldExitStates = reachedOld.getReached(exitState), null)) continue;
                    if (!this.stack.isEmpty()) {
                        this.stack.peek().incompleteCallStates.add(callState);
                    }
                    this.fixedPointReached = false;
                    break;
                }
            }
            this.cache.put(reducedEntryState, precision, currentFunction, new BlockAbstraction<ContentT>(reached, waitlist));
        }
        Collection exitStates = call != null ? (Collection)this.getExitStates(reached, this.cfa, currentFunction).stream().map(e -> this.bamCpa.getExpandOperator().expand(callState, (JvmAbstractState<ContentT>)e, entryNode, call)).map(e -> this.bamCpa.getRebuildOperator().rebuild(callState, e)).collect(Collectors.toCollection(LinkedHashSet::new)) : reached.asCollection();
        return exitStates;
    }

    private Collection<JvmAbstractState<ContentT>> getExitStates(ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reached, JvmCfa cfa, MethodSignature currentMethod) {
        ArrayList<JvmAbstractState<ContentT>> result = new ArrayList<JvmAbstractState<ContentT>>();
        for (int offset : CfaNode.EXIT_NODES_OFFSET) {
            result.addAll(reached.getReached((JvmCfaNode)cfa.getFunctionNode(currentMethod, offset)));
        }
        return result;
    }

    private boolean isCallStatic(JvmAbstractState<ContentT> callState) {
        JvmCfaNode programLocation = callState.getProgramLocation();
        String methodName = programLocation.getSignature().getMethodName();
        String descriptor = String.valueOf(programLocation.getSignature().getDescriptor());
        return (programLocation.getClazz().findMethod(methodName, descriptor).getAccessFlags() & 8) != 0;
    }

    private class StackEntry {
        public final Signature function;
        public final JvmAbstractState<ContentT> entryState;
        public final Set<JvmAbstractState<ContentT>> incompleteCallStates = new LinkedHashSet();

        public StackEntry(Signature function, JvmAbstractState<ContentT> entryState) {
            this.function = function;
            this.entryState = entryState;
        }
    }
}

