/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure;

import java.util.Objects;
import proguard.analysis.datastructure.Location;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class CodeLocation
extends Location {
    public final Clazz clazz;
    public final Member member;
    public final int offset;
    public final Signature signature;

    public CodeLocation(Clazz clazz, Member member, int offset, int line) {
        super(line);
        this.clazz = clazz;
        this.member = member;
        this.offset = offset;
        this.signature = Signature.of(clazz, member);
    }

    public String getClassName() {
        return ClassUtil.externalClassName(this.clazz.getName());
    }

    public String getMemberName() {
        return this.member == null ? null : this.member.getName(this.clazz);
    }

    @Override
    public String getName() {
        return this.signature.getFqn();
    }

    public String toString() {
        return this.signature + "+" + String.format("%04d", this.offset) + " (line " + this.line + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeLocation codeLocation = (CodeLocation)o;
        return Objects.equals(this.signature, codeLocation.signature) && this.line == codeLocation.line && this.offset == codeLocation.offset;
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.line);
    }

    @Override
    public int compareTo(Location o) {
        if (!o.getClass().equals(this.getClass())) {
            return -1;
        }
        CodeLocation other = (CodeLocation)o;
        if (this.signature.equals(other.signature)) {
            if (this.line == other.line) {
                return this.offset - other.offset;
            }
            return this.line - other.line;
        }
        return this.signature.compareTo(other.signature);
    }
}

