/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SwitchInstruction;

public class DominatorCalculator
implements AttributeVisitor {
    public static final int EXIT_NODE_OFFSET = -1;
    public static final int ENTRY_NODE_OFFSET = -2;
    private static final List<Byte> UNCONDITIONAL_BRANCHES = Arrays.asList((byte)-89, (byte)-56, (byte)-88, (byte)-55);
    private static final List<Byte> RETURN_INSTRUCTIONS = Arrays.asList((byte)-79, (byte)-84, (byte)-83, (byte)-82, (byte)-81, (byte)-80);
    private final Map<Integer, BitSet> dominatorMap = new HashMap<Integer, BitSet>();
    private int bitSetSize = 0;

    public boolean dominates(int dominator, int inferior) {
        BitSet dominators = this.dominatorMap.get(inferior);
        if (dominators == null) {
            throw new IllegalStateException("No dominator information known for offset " + inferior);
        }
        return dominators.get(this.offsetToIndex(dominator));
    }

    private int offsetToIndex(int offset) {
        return offset + 2;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.dominatorMap.clear();
        this.bitSetSize = this.offsetToIndex(codeAttribute.u4codeLength);
        BitSet entryDominators = new BitSet(this.bitSetSize);
        entryDominators.set(this.offsetToIndex(-2));
        this.dominatorMap.put(-2, entryDominators);
        this.dominatorMap.put(-1, this.initBitSet());
        this.propagateToSuccessor(-2, 0);
        this.run(codeAttribute);
    }

    private void run(CodeAttribute codeAttribute) {
        LinkedHashSet<Integer> workList = new LinkedHashSet<Integer>();
        workList.add(0);
        while (!workList.isEmpty()) {
            int offset = (Integer)workList.stream().skip(workList.size() - 1).findFirst().orElseThrow(() -> new IllegalStateException("Can't get last element in non-empty work list"));
            workList.remove(offset);
            Instruction instruction = InstructionFactory.create(codeAttribute.code, offset);
            int instructionLength = instruction.length(offset);
            int nextOffset = offset + instructionLength;
            boolean nextOffsetExists = nextOffset < codeAttribute.u4codeLength;
            HashSet<Integer> successors = new HashSet<Integer>();
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                successors.add(offset + branch.branchOffset);
                if (nextOffsetExists && !UNCONDITIONAL_BRANCHES.contains(branch.opcode)) {
                    successors.add(nextOffset);
                }
            } else if (instruction instanceof SwitchInstruction) {
                SwitchInstruction switchInstruction = (SwitchInstruction)instruction;
                successors.add(offset + switchInstruction.defaultOffset);
                for (int jumpOffset : switchInstruction.jumpOffsets) {
                    successors.add(offset + jumpOffset);
                }
            } else if (RETURN_INSTRUCTIONS.contains(instruction.opcode)) {
                this.propagateToSuccessor(offset, -1);
            } else if (nextOffsetExists) {
                successors.add(nextOffset);
            }
            Iterator iterator = successors.iterator();
            while (iterator.hasNext()) {
                int successor = (Integer)iterator.next();
                if (!this.propagateToSuccessor(offset, successor)) continue;
                workList.add(successor);
            }
        }
    }

    private BitSet initBitSet() {
        BitSet result = new BitSet(this.bitSetSize);
        result.set(0, this.bitSetSize);
        return result;
    }

    private boolean propagateToSuccessor(int curr, int successor) {
        BitSet currDominators = this.dominatorMap.computeIfAbsent(curr, o -> this.initBitSet());
        BitSet successorDominators = this.dominatorMap.computeIfAbsent(successor, o -> this.initBitSet());
        BitSet beforePropagation = (BitSet)successorDominators.clone();
        successorDominators.and(currDominators);
        successorDominators.set(this.offsetToIndex(successor));
        return !beforePropagation.equals(successorDominators);
    }
}

