/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.fixer.kotlin.KotlinAnnotationFlagFixer;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.shrink.ClassShrinker;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.KotlinModuleShrinker;
import proguard.shrink.KotlinShrinker;
import proguard.shrink.ShortestClassUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.SimpleUsageMarker;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;
import proguard.util.PrintWriterUtil;
import proguard.util.kotlin.asserter.KotlinMetadataAsserter;

public class Shrinker {
    private static final Logger logger = LogManager.getLogger(Shrinker.class);
    private final Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool execute(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool) throws IOException {
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintWriter out = new PrintWriter(System.out, true);
        programClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        libraryClassPool.classesAccept((ClassVisitor)new ClassCleaner());
        SimpleUsageMarker simpleUsageMarker = this.configuration.whyAreYouKeeping == null ? new SimpleUsageMarker() : new ShortestUsageMarker();
        ClassUsageMarker classUsageMarker = this.configuration.whyAreYouKeeping == null ? new ClassUsageMarker(simpleUsageMarker) : new ShortestClassUsageMarker((ShortestUsageMarker)simpleUsageMarker, "is kept by a directive in the configuration.\n\n");
        new UsageMarker(this.configuration).mark(programClassPool, libraryClassPool, resourceFilePool, simpleUsageMarker, classUsageMarker);
        if (this.configuration.whyAreYouKeeping != null) {
            ShortestUsagePrinter shortestUsagePrinter = new ShortestUsagePrinter((ShortestUsageMarker)classUsageMarker.getUsageMarker(), this.configuration.verbose, out);
            ClassPoolVisitor whyClassPoolvisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.whyAreYouKeeping, shortestUsagePrinter, shortestUsagePrinter);
            programClassPool.accept(whyClassPoolvisitor);
            libraryClassPool.accept(whyClassPoolvisitor);
        }
        if (this.configuration.printUsage != null) {
            PrintWriter usageWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printUsage);
            try {
                programClassPool.classesAcceptAlphabetically((ClassVisitor)new UsagePrinter(simpleUsageMarker, true, usageWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printUsage, usageWriter);
            }
        }
        ClassPool newProgramClassPool = new ClassPool();
        programClassPool.classesAccept((ClassVisitor)new UsedClassFilter(simpleUsageMarker, (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassShrinker(simpleUsageMarker), new ClassPoolFiller(newProgramClassPool)})));
        libraryClassPool.classesAccept((ClassVisitor)new UsedClassFilter(simpleUsageMarker, new ClassShrinker(simpleUsageMarker)));
        if (this.configuration.keepKotlinMetadata) {
            newProgramClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinShrinker(simpleUsageMarker)));
            newProgramClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinAnnotationFlagFixer()));
            resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 8192, (ResourceFileVisitor)new KotlinModuleShrinker(simpleUsageMarker)));
            if (this.configuration.enableKotlinAsserter) {
                WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
                new KotlinMetadataAsserter().execute(programClassPool, libraryClassPool, resourceFilePool, (WarningPrinter)warningPrinter);
            }
        }
        int newProgramClassPoolSize = newProgramClassPool.size();
        ClassCounter originalClassCounter = new ClassCounter();
        programClassPool.classesAccept((ClassVisitor)new ClassProcessingFlagFilter(0, 512, (ClassVisitor)originalClassCounter));
        ClassCounter newClassCounter = new ClassCounter();
        newProgramClassPool.classesAccept((ClassVisitor)new ClassProcessingFlagFilter(0, 512, (ClassVisitor)newClassCounter));
        logger.info("Removing unused program classes and class elements...");
        logger.info("  Original number of program classes:            {}", (Object)originalClassCounter.getCount());
        logger.info("  Final number of program classes:               {}", (Object)newClassCounter.getCount());
        if (newClassCounter.getCount() != newProgramClassPoolSize) {
            logger.info("  Final number of program and injected classes:  {}", (Object)newProgramClassPoolSize);
        }
        if (!(newProgramClassPoolSize != 0 || this.configuration.warn != null && this.configuration.warn.isEmpty())) {
            if (this.configuration.ignoreWarnings) {
                logger.warn("Warning: the output jar is empty. Did you specify the proper '-keep' options?");
            } else {
                throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
            }
        }
        return newProgramClassPool;
    }
}

