/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinSyntheticClassKindFilter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NumericNameFactory;
import proguard.obfuscate.SimpleNameFactory;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;
import proguard.util.StringParser;

public class ClassObfuscator
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private final DictionaryNameFactory classNameFactory;
    private final DictionaryNameFactory packageNameFactory;
    private final boolean useMixedCaseClassNames;
    private final StringMatcher keepPackageNamesMatcher;
    private final String flattenPackageHierarchy;
    private final String repackageClasses;
    private final boolean allowAccessModification;
    private final boolean adaptKotlin;
    private final Set classNamesToAvoid = new HashSet();
    private final Map packagePrefixMap = new HashMap();
    private final Map packagePrefixPackageNameFactoryMap = new HashMap();
    private final Map packagePrefixClassNameFactoryMap = new HashMap();
    private final Map packagePrefixNumericClassNameFactoryMap = new HashMap();
    private String newClassName;
    private boolean numericClassName;

    public ClassObfuscator(ClassPool programClassPool, ClassPool libraryClassPool, DictionaryNameFactory classNameFactory, DictionaryNameFactory packageNameFactory, boolean useMixedCaseClassNames, List keepPackageNames, String flattenPackageHierarchy, String repackageClasses, boolean allowAccessModification, boolean adaptKotlin) {
        this.classNameFactory = classNameFactory;
        this.packageNameFactory = packageNameFactory;
        if (flattenPackageHierarchy != null && flattenPackageHierarchy.length() > 0) {
            flattenPackageHierarchy = flattenPackageHierarchy + '/';
        }
        if (repackageClasses != null && repackageClasses.length() > 0) {
            repackageClasses = repackageClasses + '/';
        }
        this.useMixedCaseClassNames = useMixedCaseClassNames;
        this.keepPackageNamesMatcher = keepPackageNames == null ? null : new ListParser((StringParser)new FileNameParser()).parse(keepPackageNames);
        this.flattenPackageHierarchy = flattenPackageHierarchy;
        this.repackageClasses = repackageClasses;
        this.allowAccessModification = allowAccessModification;
        this.adaptKotlin = adaptKotlin;
        this.packagePrefixMap.put("", "");
        programClassPool.classesAccept((ClassVisitor)new MyKeepCollector());
        libraryClassPool.classesAccept((ClassVisitor)new MyKeepCollector());
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.newClassName = ClassObfuscator.newClassName((Clazz)programClass);
        if (this.newClassName == null) {
            programClass.attributesAccept((AttributeVisitor)this);
            String newPackagePrefix = this.newClassName != null ? this.newClassName + '$' : this.newPackagePrefix(ClassUtil.internalPackagePrefix((String)programClass.getName()));
            this.newClassName = this.newClassName != null && this.numericClassName ? this.generateUniqueNumericClassName(newPackagePrefix) : this.generateUniqueClassName(newPackagePrefix);
            ClassObfuscator.setNewClassName((Clazz)programClass, this.newClassName);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.newClassName = libraryClass.getName();
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, (InnerClassesInfoVisitor)this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.referencedClassAccept((ClassVisitor)this);
        String innerClassName = clazz.getName();
        String outerClassName = clazz.getClassName(enclosingMethodAttribute.u2classIndex);
        this.numericClassName = this.isNumericClassName(clazz, innerClassName, outerClassName);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        String innerClassName;
        int innerClassIndex = innerClassesInfo.u2innerClassIndex;
        int outerClassIndex = innerClassesInfo.u2outerClassIndex;
        if (innerClassIndex != 0 && outerClassIndex != 0 && (innerClassName = clazz.getClassName(innerClassIndex)).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(outerClassIndex, (ConstantVisitor)this);
            String outerClassName = clazz.getClassName(outerClassIndex);
            this.numericClassName = this.isNumericClassName(clazz, innerClassName, outerClassName);
        }
    }

    private boolean isSyntheticKotlinLambdaClass(Clazz innerClass) {
        ClassCounter counter = new ClassCounter();
        innerClass.accept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinSyntheticClassKindFilter(KotlinSyntheticClassKindFilter::isLambda, (KotlinMetadataVisitor)new KotlinMetadataToClazzVisitor((ClassVisitor)counter))));
        return counter.getCount() == 1;
    }

    private boolean isNumericClassName(Clazz innerClass, String innerClassName, String outerClassName) {
        int innerClassNameLength;
        if (this.adaptKotlin && this.isSyntheticKotlinLambdaClass(innerClass)) {
            return true;
        }
        int innerClassNameStart = outerClassName.length() + 1;
        if (innerClassNameStart >= (innerClassNameLength = innerClassName.length())) {
            return false;
        }
        for (int index = innerClassNameStart; index < innerClassNameLength; ++index) {
            if (Character.isDigit(innerClassName.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept((ClassVisitor)this);
    }

    private String newPackagePrefix(String packagePrefix) {
        String newPackagePrefix = (String)this.packagePrefixMap.get(packagePrefix);
        if (newPackagePrefix == null) {
            if (this.keepPackageNamesMatcher != null && this.keepPackageNamesMatcher.matches(packagePrefix.length() > 0 ? packagePrefix.substring(0, packagePrefix.length() - 1) : packagePrefix)) {
                return packagePrefix;
            }
            if (this.repackageClasses != null) {
                return this.repackageClasses;
            }
            String newSuperPackagePrefix = this.flattenPackageHierarchy != null ? this.flattenPackageHierarchy : this.newPackagePrefix(ClassUtil.internalPackagePrefix((String)packagePrefix));
            newPackagePrefix = this.generateUniquePackagePrefix(newSuperPackagePrefix);
            this.packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return newPackagePrefix;
    }

    private String generateUniquePackagePrefix(String newSuperPackagePrefix) {
        NameFactory packageNameFactory = (NameFactory)this.packagePrefixPackageNameFactoryMap.get(newSuperPackagePrefix);
        if (packageNameFactory == null) {
            packageNameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            if (this.packageNameFactory != null) {
                packageNameFactory = new DictionaryNameFactory(this.packageNameFactory, packageNameFactory);
            }
            this.packagePrefixPackageNameFactoryMap.put(newSuperPackagePrefix, packageNameFactory);
        }
        return this.generateUniquePackagePrefix(newSuperPackagePrefix, packageNameFactory);
    }

    private String generateUniquePackagePrefix(String newSuperPackagePrefix, NameFactory packageNameFactory) {
        String newPackagePrefix;
        while (this.packagePrefixMap.containsValue(newPackagePrefix = newSuperPackagePrefix + packageNameFactory.nextName() + '/')) {
        }
        return newPackagePrefix;
    }

    private String generateUniqueClassName(String newPackagePrefix) {
        NameFactory classNameFactory = (NameFactory)this.packagePrefixClassNameFactoryMap.get(newPackagePrefix);
        if (classNameFactory == null) {
            classNameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            if (this.classNameFactory != null) {
                classNameFactory = new DictionaryNameFactory(this.classNameFactory, classNameFactory);
            }
            this.packagePrefixClassNameFactoryMap.put(newPackagePrefix, classNameFactory);
        }
        return this.generateUniqueClassName(newPackagePrefix, classNameFactory);
    }

    private String generateUniqueNumericClassName(String newPackagePrefix) {
        NameFactory classNameFactory = (NameFactory)this.packagePrefixNumericClassNameFactoryMap.get(newPackagePrefix);
        if (classNameFactory == null) {
            classNameFactory = new NumericNameFactory();
            this.packagePrefixNumericClassNameFactoryMap.put(newPackagePrefix, classNameFactory);
        }
        return this.generateUniqueClassName(newPackagePrefix, classNameFactory);
    }

    private String generateUniqueClassName(String newPackagePrefix, NameFactory classNameFactory) {
        String newClassName;
        String newMixedCaseClassName;
        while (this.classNamesToAvoid.contains(newMixedCaseClassName = this.mixedCaseClassName(newClassName = newPackagePrefix + classNameFactory.nextName()))) {
        }
        if (this.classNameFactory != null && !this.useMixedCaseClassNames) {
            this.classNamesToAvoid.add(newMixedCaseClassName);
        }
        return newClassName;
    }

    private String mixedCaseClassName(String className) {
        return this.useMixedCaseClassNames ? className : className.toLowerCase();
    }

    public static void setNewClassName(Clazz clazz, String name) {
        clazz.setProcessingInfo((Object)name);
    }

    public static boolean hasOriginalClassName(Clazz clazz) {
        return clazz.getName().equals(ClassObfuscator.newClassName(clazz));
    }

    public static String newClassName(Clazz clazz) {
        Object processingInfo = clazz.getProcessingInfo();
        return processingInfo instanceof String ? (String)processingInfo : null;
    }

    private class MyKeepCollector
    implements ClassVisitor {
        private MyKeepCollector() {
        }

        public void visitAnyClass(Clazz clazz) {
        }

        public void visitProgramClass(ProgramClass programClass) {
            String newClassName = ClassObfuscator.newClassName((Clazz)programClass);
            if (newClassName != null) {
                ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(newClassName));
                if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                    String className = programClass.getName();
                    this.mapPackageName(className, newClassName, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
                }
            }
        }

        public void visitLibraryClass(LibraryClass libraryClass) {
            String newClassName = ClassObfuscator.newClassName((Clazz)libraryClass);
            if (newClassName == null) {
                newClassName = libraryClass.getName();
            }
            ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(newClassName));
            if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                String className = libraryClass.getName();
                this.mapPackageName(className, newClassName, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
            }
        }

        private void mapPackageName(String className, String newClassName, boolean recursively) {
            String packagePrefix = ClassUtil.internalPackagePrefix((String)className);
            String newPackagePrefix = ClassUtil.internalPackagePrefix((String)newClassName);
            do {
                ClassObfuscator.this.packagePrefixMap.put(packagePrefix, newPackagePrefix);
                if (!recursively) break;
                packagePrefix = ClassUtil.internalPackagePrefix((String)packagePrefix);
                newPackagePrefix = ClassUtil.internalPackagePrefix((String)newPackagePrefix);
            } while (packagePrefix.length() > 0 && newPackagePrefix.length() > 0);
        }
    }
}

