/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.Configuration;
import proguard.ConfigurationChecker;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.GPL;
import proguard.Initializer;
import proguard.InputReader;
import proguard.OutputWriter;
import proguard.SeedPrinter;
import proguard.Targeter;
import proguard.UpToDateChecker;
import proguard.backport.Backporter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ClassElementSorter;
import proguard.classfile.editor.LineNumberTableAttributeTrimmer;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.io.kotlin.KotlinMetadataWriter;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.ArrayInitializationReplacer;
import proguard.classfile.util.PrimitiveArrayConstantReplacer;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.configuration.ConfigurationLoggingAdder;
import proguard.configuration.InitialStateInfo;
import proguard.evaluation.IncompleteClassHierarchyException;
import proguard.io.ExtraDataEntryNameMap;
import proguard.logging.Logging;
import proguard.mark.Marker;
import proguard.obfuscate.Obfuscator;
import proguard.optimize.Optimizer;
import proguard.optimize.gson.GsonOptimizer;
import proguard.optimize.peephole.LineNumberLinearizer;
import proguard.preverify.Preverifier;
import proguard.preverify.SubroutineInliner;
import proguard.resources.file.ResourceFilePool;
import proguard.shrink.Shrinker;
import proguard.strip.KotlinAnnotationStripper;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.PrintWriterUtil;
import proguard.util.StringParser;

public class ProGuard {
    private static final Logger logger = LogManager.getLogger(ProGuard.class);
    public static final String VERSION = "ProGuard, version " + ProGuard.getVersion();
    private final Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private final ClassPool libraryClassPool = new ClassPool();
    private final ResourceFilePool resourceFilePool = new ResourceFilePool();
    private InitialStateInfo initialStateInfo;
    private final ExtraDataEntryNameMap extraDataEntryNameMap = new ExtraDataEntryNameMap();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        Logging.configureVerbosity(this.configuration.verbose);
        logger.always().log(VERSION);
        GPL.check();
        try {
            if (this.configuration.printConfiguration != null) {
                this.printConfiguration();
            }
            new ConfigurationChecker(this.configuration).check();
            if (this.configuration.programJars != null && this.configuration.programJars.hasOutput() && new UpToDateChecker(this.configuration).check()) {
                return;
            }
            if (this.configuration.targetClassVersion != 0) {
                this.configuration.backport = true;
            }
            this.readInput();
            if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
                this.clearPreverification();
            }
            if (this.configuration.printSeeds != null || this.configuration.backport || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify || this.configuration.addConfigurationDebugging || this.configuration.keepKotlinMetadata) {
                this.initialize();
                this.mark();
            }
            if (this.configuration.addConfigurationDebugging) {
                this.initialStateInfo = new InitialStateInfo(this.programClassPool);
            }
            if (this.configuration.keepKotlinMetadata) {
                this.stripKotlinMetadataAnnotations();
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                this.introducePrimitiveArrayConstants();
            }
            if (this.configuration.backport) {
                this.backport();
            }
            if (this.configuration.addConfigurationDebugging) {
                this.addConfigurationLogging();
            }
            if (this.configuration.printSeeds != null) {
                this.printSeeds();
            }
            if (this.configuration.preverify || this.configuration.android) {
                this.inlineSubroutines();
            }
            if (this.configuration.shrink) {
                this.shrink();
            }
            if (this.configuration.optimize) {
                this.optimizeGson();
            }
            if (this.configuration.optimize) {
                for (int optimizationPass = 0; optimizationPass < this.configuration.optimizationPasses && this.optimize(optimizationPass + 1, this.configuration.optimizationPasses); ++optimizationPass) {
                    if (!this.configuration.shrink) continue;
                    this.configuration.printUsage = null;
                    this.configuration.whyAreYouKeeping = null;
                    this.shrink();
                }
                this.linearizeLineNumbers();
            }
            if (this.configuration.obfuscate) {
                this.obfuscate();
            }
            if (this.configuration.keepKotlinMetadata) {
                this.keepKotlinMetadata();
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                this.expandPrimitiveArrayConstants();
            }
            if (this.configuration.targetClassVersion != 0) {
                this.target();
            }
            if (this.configuration.preverify) {
                this.preverify();
            }
            if (this.configuration.optimize || this.configuration.preverify) {
                this.trimLineNumbers();
            }
            if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
                this.sortClassElements();
            }
            if (this.configuration.programJars.hasOutput()) {
                this.writeOutput();
            }
            if (this.configuration.dump != null) {
                this.dump();
            }
        }
        catch (IncompleteClassHierarchyException e) {
            throw new RuntimeException(System.lineSeparator() + System.lineSeparator() + "It appears you are missing some classes resulting in an incomplete class hierarchy, " + System.lineSeparator() + "please refer to the troubleshooting page in the manual: " + System.lineSeparator() + "https://www.guardsquare.com/en/products/proguard/manual/troubleshooting#superclass" + System.lineSeparator());
        }
    }

    private void printConfiguration() throws IOException {
        logger.info("Printing configuration to [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.printConfiguration));
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.printConfiguration);
        try {
            new ConfigurationWriter(pw).write(this.configuration);
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printConfiguration, pw);
        }
    }

    private void readInput() throws IOException {
        logger.info("Reading input...");
        new InputReader(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void initialize() throws IOException {
        logger.info("Initializing...");
        new Initializer(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void mark() {
        logger.info("Marking classes and class members to be kept...");
        new Marker(this.configuration).mark(this.programClassPool, this.libraryClassPool);
    }

    private void stripKotlinMetadataAnnotations() {
        new KotlinAnnotationStripper().execute(this.configuration, this.programClassPool, this.libraryClassPool);
    }

    private void introducePrimitiveArrayConstants() {
        this.programClassPool.classesAccept((ClassVisitor)new ArrayInitializationReplacer());
    }

    private void expandPrimitiveArrayConstants() {
        this.programClassPool.classesAccept((ClassVisitor)new PrimitiveArrayConstantReplacer());
    }

    private void backport() {
        new Backporter(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap);
    }

    private void addConfigurationLogging() throws IOException {
        new ConfigurationLoggingAdder().execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap);
    }

    private void keepKotlinMetadata() {
        logger.info("Adapting Kotlin metadata...");
        WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
        ClassCounter counter = new ClassCounter();
        this.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)new KotlinMetadataWriter((WarningPrinter)warningPrinter, (ClassVisitor)counter)));
        logger.info("  Number of Kotlin classes adapted:              {}", (Object)counter.getCount());
    }

    private void target() throws IOException {
        logger.info("Setting target versions...");
        new Targeter(this.configuration).execute(this.programClassPool);
    }

    private void printSeeds() throws IOException {
        logger.info("Printing kept classes, fields, and methods...");
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.printSeeds);
        try {
            new SeedPrinter(pw).write(this.configuration, this.programClassPool, this.libraryClassPool);
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printSeeds, pw);
        }
    }

    private void shrink() throws IOException {
        logger.info("Shrinking...");
        if (this.configuration.whyAreYouKeeping != null) {
            logger.info("Explaining why classes and class members are being kept...");
        }
        if (this.configuration.printUsage != null) {
            logger.info("Printing usage to [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.printUsage));
        }
        this.programClassPool = new Shrinker(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void inlineSubroutines() {
        logger.info("Inlining subroutines...");
        new SubroutineInliner(this.configuration).execute(this.programClassPool);
    }

    private void optimizeGson() throws IOException {
        if (this.programClassPool.getClass("com/google/gson/Gson") != null && (this.configuration.optimizations == null || new ListParser((StringParser)new NameParser()).parse(this.configuration.optimizations).matches("library/gson"))) {
            logger.info("Optimizing usages of Gson library...");
            new GsonOptimizer().execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap, this.configuration);
        }
    }

    private boolean optimize(int currentPass, int maxPasses) throws IOException {
        logger.info("Optimizing (pass {}/{})...", (Object)currentPass, (Object)maxPasses);
        return new Optimizer(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap);
    }

    private void obfuscate() throws IOException {
        logger.info("Obfuscating...");
        new Obfuscator(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void linearizeLineNumbers() {
        this.programClassPool.classesAccept((ClassVisitor)new LineNumberLinearizer());
    }

    private void trimLineNumbers() {
        this.programClassPool.classesAccept((ClassVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new LineNumberTableAttributeTrimmer()));
    }

    private void clearPreverification() {
        this.programClassPool.classesAccept((ClassVisitor)new ClassVersionFilter(0x320000, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new NamedAttributeDeleter("StackMapTable")))));
    }

    private void preverify() {
        logger.info("Preverifying...");
        new Preverifier(this.configuration).execute(this.programClassPool);
    }

    private void sortClassElements() {
        this.programClassPool.classesAccept((ClassVisitor)new ClassElementSorter());
    }

    private void writeOutput() throws IOException {
        logger.info("Writing output...");
        new OutputWriter(this.configuration).execute(this.programClassPool, this.initialStateInfo, this.resourceFilePool, this.extraDataEntryNameMap);
    }

    private void dump() throws IOException {
        logger.info("Printing classes to [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.dump));
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.dump);
        try {
            this.programClassPool.classesAccept((ClassVisitor)new ClassPrinter(pw));
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.dump, pw);
        }
    }

    public static String getVersion() {
        String version;
        Package pack = ProGuard.class.getPackage();
        if (pack != null && (version = pack.getImplementationVersion()) != null) {
            return version;
        }
        return "undefined";
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            logger.warn(VERSION);
            logger.warn("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            try (ConfigurationParser parser = new ConfigurationParser(args, System.getProperties());){
                parser.parse(configuration);
            }
            new ProGuard(configuration).execute();
        }
        catch (Exception ex) {
            logger.error("Unexpected error", (Throwable)ex);
            System.exit(1);
        }
        System.exit(0);
    }
}

