/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Content;
import com.google.genai.types.DatasetDistribution;
import com.google.genai.types.DatasetStats;
import java.util.List;
import java.util.Optional;

final class AutoValue_DatasetStats
extends DatasetStats {
    private final Optional<Long> totalBillableCharacterCount;
    private final Optional<Long> totalTuningCharacterCount;
    private final Optional<Long> tuningDatasetExampleCount;
    private final Optional<Long> tuningStepCount;
    private final Optional<List<Content>> userDatasetExamples;
    private final Optional<DatasetDistribution> userInputTokenDistribution;
    private final Optional<DatasetDistribution> userMessagePerExampleDistribution;
    private final Optional<DatasetDistribution> userOutputTokenDistribution;

    private AutoValue_DatasetStats(Optional<Long> totalBillableCharacterCount, Optional<Long> totalTuningCharacterCount, Optional<Long> tuningDatasetExampleCount, Optional<Long> tuningStepCount, Optional<List<Content>> userDatasetExamples, Optional<DatasetDistribution> userInputTokenDistribution, Optional<DatasetDistribution> userMessagePerExampleDistribution, Optional<DatasetDistribution> userOutputTokenDistribution) {
        this.totalBillableCharacterCount = totalBillableCharacterCount;
        this.totalTuningCharacterCount = totalTuningCharacterCount;
        this.tuningDatasetExampleCount = tuningDatasetExampleCount;
        this.tuningStepCount = tuningStepCount;
        this.userDatasetExamples = userDatasetExamples;
        this.userInputTokenDistribution = userInputTokenDistribution;
        this.userMessagePerExampleDistribution = userMessagePerExampleDistribution;
        this.userOutputTokenDistribution = userOutputTokenDistribution;
    }

    @Override
    @JsonProperty(value="totalBillableCharacterCount")
    public Optional<Long> totalBillableCharacterCount() {
        return this.totalBillableCharacterCount;
    }

    @Override
    @JsonProperty(value="totalTuningCharacterCount")
    public Optional<Long> totalTuningCharacterCount() {
        return this.totalTuningCharacterCount;
    }

    @Override
    @JsonProperty(value="tuningDatasetExampleCount")
    public Optional<Long> tuningDatasetExampleCount() {
        return this.tuningDatasetExampleCount;
    }

    @Override
    @JsonProperty(value="tuningStepCount")
    public Optional<Long> tuningStepCount() {
        return this.tuningStepCount;
    }

    @Override
    @JsonProperty(value="userDatasetExamples")
    public Optional<List<Content>> userDatasetExamples() {
        return this.userDatasetExamples;
    }

    @Override
    @JsonProperty(value="userInputTokenDistribution")
    public Optional<DatasetDistribution> userInputTokenDistribution() {
        return this.userInputTokenDistribution;
    }

    @Override
    @JsonProperty(value="userMessagePerExampleDistribution")
    public Optional<DatasetDistribution> userMessagePerExampleDistribution() {
        return this.userMessagePerExampleDistribution;
    }

    @Override
    @JsonProperty(value="userOutputTokenDistribution")
    public Optional<DatasetDistribution> userOutputTokenDistribution() {
        return this.userOutputTokenDistribution;
    }

    public String toString() {
        return "DatasetStats{totalBillableCharacterCount=" + this.totalBillableCharacterCount + ", totalTuningCharacterCount=" + this.totalTuningCharacterCount + ", tuningDatasetExampleCount=" + this.tuningDatasetExampleCount + ", tuningStepCount=" + this.tuningStepCount + ", userDatasetExamples=" + this.userDatasetExamples + ", userInputTokenDistribution=" + this.userInputTokenDistribution + ", userMessagePerExampleDistribution=" + this.userMessagePerExampleDistribution + ", userOutputTokenDistribution=" + this.userOutputTokenDistribution + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatasetStats) {
            DatasetStats that = (DatasetStats)o;
            return this.totalBillableCharacterCount.equals(that.totalBillableCharacterCount()) && this.totalTuningCharacterCount.equals(that.totalTuningCharacterCount()) && this.tuningDatasetExampleCount.equals(that.tuningDatasetExampleCount()) && this.tuningStepCount.equals(that.tuningStepCount()) && this.userDatasetExamples.equals(that.userDatasetExamples()) && this.userInputTokenDistribution.equals(that.userInputTokenDistribution()) && this.userMessagePerExampleDistribution.equals(that.userMessagePerExampleDistribution()) && this.userOutputTokenDistribution.equals(that.userOutputTokenDistribution());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.totalBillableCharacterCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.totalTuningCharacterCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.tuningDatasetExampleCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.tuningStepCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.userDatasetExamples.hashCode();
        h$ *= 1000003;
        h$ ^= this.userInputTokenDistribution.hashCode();
        h$ *= 1000003;
        h$ ^= this.userMessagePerExampleDistribution.hashCode();
        h$ *= 1000003;
        return h$ ^= this.userOutputTokenDistribution.hashCode();
    }

    @Override
    public DatasetStats.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DatasetStats.Builder {
        private Optional<Long> totalBillableCharacterCount = Optional.empty();
        private Optional<Long> totalTuningCharacterCount = Optional.empty();
        private Optional<Long> tuningDatasetExampleCount = Optional.empty();
        private Optional<Long> tuningStepCount = Optional.empty();
        private Optional<List<Content>> userDatasetExamples = Optional.empty();
        private Optional<DatasetDistribution> userInputTokenDistribution = Optional.empty();
        private Optional<DatasetDistribution> userMessagePerExampleDistribution = Optional.empty();
        private Optional<DatasetDistribution> userOutputTokenDistribution = Optional.empty();

        Builder() {
        }

        Builder(DatasetStats source) {
            this.totalBillableCharacterCount = source.totalBillableCharacterCount();
            this.totalTuningCharacterCount = source.totalTuningCharacterCount();
            this.tuningDatasetExampleCount = source.tuningDatasetExampleCount();
            this.tuningStepCount = source.tuningStepCount();
            this.userDatasetExamples = source.userDatasetExamples();
            this.userInputTokenDistribution = source.userInputTokenDistribution();
            this.userMessagePerExampleDistribution = source.userMessagePerExampleDistribution();
            this.userOutputTokenDistribution = source.userOutputTokenDistribution();
        }

        @Override
        public DatasetStats.Builder totalBillableCharacterCount(Long totalBillableCharacterCount) {
            this.totalBillableCharacterCount = Optional.of(totalBillableCharacterCount);
            return this;
        }

        @Override
        public DatasetStats.Builder totalTuningCharacterCount(Long totalTuningCharacterCount) {
            this.totalTuningCharacterCount = Optional.of(totalTuningCharacterCount);
            return this;
        }

        @Override
        public DatasetStats.Builder tuningDatasetExampleCount(Long tuningDatasetExampleCount) {
            this.tuningDatasetExampleCount = Optional.of(tuningDatasetExampleCount);
            return this;
        }

        @Override
        public DatasetStats.Builder tuningStepCount(Long tuningStepCount) {
            this.tuningStepCount = Optional.of(tuningStepCount);
            return this;
        }

        @Override
        public DatasetStats.Builder userDatasetExamples(List<Content> userDatasetExamples) {
            this.userDatasetExamples = Optional.of(userDatasetExamples);
            return this;
        }

        @Override
        public DatasetStats.Builder userInputTokenDistribution(DatasetDistribution userInputTokenDistribution) {
            this.userInputTokenDistribution = Optional.of(userInputTokenDistribution);
            return this;
        }

        @Override
        public DatasetStats.Builder userMessagePerExampleDistribution(DatasetDistribution userMessagePerExampleDistribution) {
            this.userMessagePerExampleDistribution = Optional.of(userMessagePerExampleDistribution);
            return this;
        }

        @Override
        public DatasetStats.Builder userOutputTokenDistribution(DatasetDistribution userOutputTokenDistribution) {
            this.userOutputTokenDistribution = Optional.of(userOutputTokenDistribution);
            return this;
        }

        @Override
        public DatasetStats build() {
            return new AutoValue_DatasetStats(this.totalBillableCharacterCount, this.totalTuningCharacterCount, this.tuningDatasetExampleCount, this.tuningStepCount, this.userDatasetExamples, this.userInputTokenDistribution, this.userMessagePerExampleDistribution, this.userOutputTokenDistribution);
        }
    }
}

