/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.Preconditions;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.encryption.BackupEncryptionConfig;
import com.google.cloud.spanner.encryption.EncryptionInfo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class BackupInfo {
    private final BackupId id;
    private final State state;
    private final Timestamp expireTime;
    private final Timestamp versionTime;
    private final DatabaseId database;
    private final long size;
    private final BackupEncryptionConfig encryptionConfig;
    private final EncryptionInfo encryptionInfo;
    private final com.google.spanner.admin.database.v1.Backup proto;
    private final Timestamp maxExpireTime;
    private final List<String> referencingBackups;

    BackupInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.size = builder.size;
        this.encryptionConfig = builder.encryptionConfig;
        this.encryptionInfo = builder.encryptionInfo;
        this.expireTime = builder.expireTime;
        this.versionTime = builder.versionTime;
        this.database = builder.database;
        this.proto = builder.proto;
        this.maxExpireTime = builder.maxExpireTime;
        this.referencingBackups = builder.referencingBackups;
    }

    public BackupId getId() {
        return this.id;
    }

    public InstanceId getInstanceId() {
        return this.id.getInstanceId();
    }

    public State getState() {
        return this.state;
    }

    public long getSize() {
        return this.size;
    }

    public BackupEncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.encryptionInfo;
    }

    public Timestamp getExpireTime() {
        return this.expireTime;
    }

    public Timestamp getVersionTime() {
        return this.versionTime;
    }

    public DatabaseId getDatabase() {
        return this.database;
    }

    @Nullable
    public com.google.spanner.admin.database.v1.Backup getProto() {
        return this.proto;
    }

    public Timestamp getMaxExpireTime() {
        return this.maxExpireTime;
    }

    public List<String> getReferencingBackups() {
        return this.referencingBackups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupInfo that = (BackupInfo)o;
        return this.id.equals(that.id) && this.state == that.state && this.size == that.size && Objects.equals(this.encryptionConfig, that.encryptionConfig) && Objects.equals(this.encryptionInfo, that.encryptionInfo) && Objects.equals(this.expireTime, that.expireTime) && Objects.equals(this.versionTime, that.versionTime) && Objects.equals(this.database, that.database) && Objects.equals(this.maxExpireTime, that.maxExpireTime) && Objects.equals(this.referencingBackups, that.referencingBackups);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.size, this.encryptionConfig, this.encryptionInfo, this.expireTime, this.versionTime, this.database, this.maxExpireTime, this.referencingBackups});
    }

    public String toString() {
        return String.format("Backup[%s, %s, %d, %s, %s, %s, %s, %s, %s, %s]", new Object[]{this.id.getName(), this.state, this.size, this.encryptionConfig, this.encryptionInfo, this.expireTime, this.versionTime, this.database, this.maxExpireTime, this.referencingBackups});
    }

    public static enum State {
        UNSPECIFIED,
        CREATING,
        READY;

    }

    static abstract class BuilderImpl
    extends Builder {
        protected final BackupId id;
        private State state = State.UNSPECIFIED;
        private Timestamp expireTime;
        private Timestamp versionTime;
        private DatabaseId database;
        private long size;
        private BackupEncryptionConfig encryptionConfig;
        private EncryptionInfo encryptionInfo;
        private com.google.spanner.admin.database.v1.Backup proto;
        private Timestamp maxExpireTime;
        private List<String> referencingBackups;

        BuilderImpl(BackupId id) {
            this.id = (BackupId)Preconditions.checkNotNull((Object)id);
        }

        BuilderImpl(BackupInfo other) {
            this.id = other.id;
            this.state = other.state;
            this.expireTime = other.expireTime;
            this.versionTime = other.versionTime;
            this.database = other.database;
            this.size = other.size;
            this.encryptionConfig = other.encryptionConfig;
            this.encryptionInfo = other.encryptionInfo;
            this.proto = other.proto;
            this.maxExpireTime = other.maxExpireTime;
            this.referencingBackups = other.referencingBackups;
        }

        @Override
        Builder setState(State state) {
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            return this;
        }

        @Override
        public Builder setExpireTime(Timestamp expireTime) {
            this.expireTime = (Timestamp)Preconditions.checkNotNull((Object)expireTime);
            return this;
        }

        @Override
        public Builder setVersionTime(Timestamp versionTime) {
            this.versionTime = versionTime;
            return this;
        }

        @Override
        public Builder setDatabase(DatabaseId database) {
            Preconditions.checkArgument((boolean)database.getInstanceId().equals(this.id.getInstanceId()), (Object)"The instance of the source database must be equal to the instance of the backup.");
            this.database = (DatabaseId)Preconditions.checkNotNull((Object)database);
            return this;
        }

        @Override
        public Builder setEncryptionConfig(BackupEncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        @Override
        Builder setSize(long size) {
            this.size = size;
            return this;
        }

        @Override
        Builder setEncryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        @Override
        Builder setProto(@Nullable com.google.spanner.admin.database.v1.Backup proto) {
            this.proto = proto;
            return this;
        }

        @Override
        protected Builder setMaxExpireTime(Timestamp maxExpireTime) {
            this.maxExpireTime = (Timestamp)Preconditions.checkNotNull((Object)maxExpireTime);
            return this;
        }

        @Override
        protected Builder addAllReferencingBackups(List<String> referencingBackups) {
            this.referencingBackups = (List)Preconditions.checkNotNull(referencingBackups);
            return this;
        }
    }

    public static abstract class Builder {
        abstract Builder setState(State var1);

        abstract Builder setSize(long var1);

        abstract Builder setEncryptionInfo(EncryptionInfo var1);

        abstract Builder setProto(com.google.spanner.admin.database.v1.Backup var1);

        public abstract Builder setEncryptionConfig(BackupEncryptionConfig var1);

        public abstract Builder setExpireTime(Timestamp var1);

        public abstract Builder setVersionTime(Timestamp var1);

        public abstract Builder setDatabase(DatabaseId var1);

        public abstract Backup build();

        protected Builder setMaxExpireTime(Timestamp maxExpireTime) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        protected Builder addAllReferencingBackups(List<String> referencingBackups) {
            throw new UnsupportedOperationException("Unimplemented");
        }
    }
}

