/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.util;

import com.google.appengine.repackaged.com.google.common.time.TimeSource;
import com.google.appengine.repackaged.com.google.errorprone.annotations.PreferStaticImport;
import com.google.appengine.repackaged.com.google.protobuf.Duration;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.util.Durations;
import com.google.appengine.repackaged.com.google.protobuf.util.Timestamps;
import java.time.Instant;

public final class JavaTimeConversions {
    private JavaTimeConversions() {
    }

    @PreferStaticImport
    public static Instant toJavaInstant(Timestamp timestamp) {
        timestamp = Timestamps.normalizedTimestamp(timestamp.getSeconds(), timestamp.getNanos());
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    @PreferStaticImport
    public static java.time.Duration toJavaDuration(Duration duration) {
        duration = Durations.normalizedDuration(duration.getSeconds(), duration.getNanos());
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }

    @PreferStaticImport
    public static Timestamp toProtoTimestamp(Instant instant) {
        return Timestamps.normalizedTimestamp(instant.getEpochSecond(), instant.getNano());
    }

    @PreferStaticImport
    public static Duration toProtoDuration(java.time.Duration duration) {
        return Durations.normalizedDuration(duration.getSeconds(), duration.getNano());
    }

    public static Timestamp now(TimeSource timeSource) {
        return JavaTimeConversions.toProtoTimestamp(timeSource.now());
    }
}

