/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class SpecializedLogSiteKey
implements LogSiteKey {
    private final LogSiteKey delegate;
    private final Object qualifier;

    static LogSiteKey of(LogSiteKey key, Object qualifier) {
        return new SpecializedLogSiteKey(key, qualifier);
    }

    private SpecializedLogSiteKey(LogSiteKey key, Object qualifier) {
        this.delegate = Checks.checkNotNull(key, "log site key");
        this.qualifier = Checks.checkNotNull(qualifier, "log site qualifier");
    }

    public boolean equals(@NullableDecl Object obj) {
        if (!(obj instanceof SpecializedLogSiteKey)) {
            return false;
        }
        SpecializedLogSiteKey other = (SpecializedLogSiteKey)obj;
        return this.delegate.equals(other.delegate) && this.qualifier.equals(other.qualifier);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ this.qualifier.hashCode();
    }

    public String toString() {
        String string = String.valueOf(this.delegate);
        String string2 = String.valueOf(this.qualifier);
        return new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length()).append("SpecializedLogSiteKey{ delegate='").append(string).append("', qualifier='").append(string2).append("' }").toString();
    }
}

