/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class QuerySplitComponent
implements Comparable<QuerySplitComponent> {
    private final Order order;
    private final String propertyName;
    private final int sortIndex;
    private final Query.SortDirection direction;
    private final List<List<Query.FilterPredicate>> filters = new ArrayList<List<Query.FilterPredicate>>();

    public QuerySplitComponent(String propertyName, List<Query.SortPredicate> sorts) {
        this.propertyName = propertyName;
        for (int i = 0; i < sorts.size(); ++i) {
            if (!sorts.get(i).getPropertyName().equals(propertyName)) continue;
            this.order = Order.SEQUENTIAL;
            this.sortIndex = i;
            this.direction = sorts.get(i).getDirection();
            return;
        }
        this.order = Order.ARBITRARY;
        this.sortIndex = -1;
        this.direction = null;
    }

    public void addFilters(Query.FilterPredicate ... filters) {
        this.filters.add(Arrays.asList(filters));
    }

    public List<List<Query.FilterPredicate>> getFilters() {
        return this.filters;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public Query.SortDirection getDirection() {
        return this.direction;
    }

    @Override
    public int compareTo(QuerySplitComponent o) {
        if (!this.order.equals((Object)o.order)) {
            return this.order.compareTo(o.order);
        }
        return Integer.compare(this.sortIndex, o.sortIndex);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.direction, this.filters, this.order, this.propertyName, this.sortIndex});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuerySplitComponent)) {
            return false;
        }
        QuerySplitComponent other = (QuerySplitComponent)obj;
        return Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.filters, other.filters) && Objects.equals((Object)this.order, (Object)other.order) && Objects.equals(this.propertyName, other.propertyName) && this.sortIndex == other.sortIndex;
    }

    public String toString() {
        String string = String.valueOf(this.filters);
        String result = new StringBuilder(29 + String.valueOf(string).length()).append("QuerySplitComponent [filters=").append(string).toString();
        if (this.direction != null) {
            string = String.valueOf(result);
            String string2 = String.valueOf((Object)this.direction);
            int n = this.sortIndex;
            result = new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(", direction=").append(string2).append(", sortIndex=").append(n).toString();
        }
        return String.valueOf(result).concat("]");
    }

    static enum Order {
        SEQUENTIAL,
        ARBITRARY;

    }
}

