/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.profitsharing;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.profitsharing.model.AddReceiverRequest;
import com.wechat.pay.java.service.profitsharing.model.AddReceiverResponse;
import com.wechat.pay.java.service.profitsharing.model.CreateOrderRequest;
import com.wechat.pay.java.service.profitsharing.model.CreateReturnOrderRequest;
import com.wechat.pay.java.service.profitsharing.model.DeleteReceiverRequest;
import com.wechat.pay.java.service.profitsharing.model.DeleteReceiverResponse;
import com.wechat.pay.java.service.profitsharing.model.OrdersEntity;
import com.wechat.pay.java.service.profitsharing.model.QueryMerchantRatioRequest;
import com.wechat.pay.java.service.profitsharing.model.QueryMerchantRatioResponse;
import com.wechat.pay.java.service.profitsharing.model.QueryOrderAmountRequest;
import com.wechat.pay.java.service.profitsharing.model.QueryOrderAmountResponse;
import com.wechat.pay.java.service.profitsharing.model.QueryOrderRequest;
import com.wechat.pay.java.service.profitsharing.model.QueryReturnOrderRequest;
import com.wechat.pay.java.service.profitsharing.model.ReturnOrdersEntity;
import com.wechat.pay.java.service.profitsharing.model.SplitBillRequest;
import com.wechat.pay.java.service.profitsharing.model.SplitBillResponse;
import com.wechat.pay.java.service.profitsharing.model.UnfreezeOrderRequest;
import java.util.Objects;

public class ProfitsharingService {
    private final HttpClient httpClient;
    private final HostName hostName;
    private final PrivacyEncryptor encryptor;
    private final PrivacyDecryptor decryptor;

    private ProfitsharingService(HttpClient httpClient, HostName hostName, PrivacyEncryptor encryptor, PrivacyDecryptor decryptor) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
        this.encryptor = Objects.requireNonNull(encryptor);
        this.decryptor = Objects.requireNonNull(decryptor);
    }

    public SplitBillResponse splitBill(SplitBillRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/bills";
        SplitBillRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getBillDate() != null) {
            queryParameter.add("bill_date", (Object)UrlEncoder.urlEncode((String)realRequest.getBillDate()));
        }
        if (realRequest.getTarType() != null) {
            queryParameter.add("tar_type", (Object)UrlEncoder.urlEncode((String)realRequest.getTarType().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SplitBillResponse.class);
        return (SplitBillResponse)httpResponse.getServiceResponse();
    }

    public QueryMerchantRatioResponse queryMerchantRatio(QueryMerchantRatioRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/merchant-configs/{sub_mchid}";
        QueryMerchantRatioRequest realRequest = request;
        requestPath = requestPath.replace("{sub_mchid}", UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryMerchantRatioResponse.class);
        return (QueryMerchantRatioResponse)httpResponse.getServiceResponse();
    }

    public OrdersEntity createOrder(CreateOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/orders";
        CreateOrderRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, OrdersEntity.class);
        return (OrdersEntity)httpResponse.getServiceResponse();
    }

    public OrdersEntity queryOrder(QueryOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/orders/{out_order_no}";
        QueryOrderRequest realRequest = request;
        requestPath = requestPath.replace("{out_order_no}", UrlEncoder.urlEncode((String)realRequest.getOutOrderNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getTransactionId() != null) {
            queryParameter.add("transaction_id", (Object)UrlEncoder.urlEncode((String)realRequest.getTransactionId()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, OrdersEntity.class);
        return (OrdersEntity)httpResponse.getServiceResponse();
    }

    public OrdersEntity unfreezeOrder(UnfreezeOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/orders/unfreeze";
        UnfreezeOrderRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, OrdersEntity.class);
        return (OrdersEntity)httpResponse.getServiceResponse();
    }

    public AddReceiverResponse addReceiver(AddReceiverRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/receivers/add";
        AddReceiverRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AddReceiverResponse.class);
        return ((AddReceiverResponse)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    public DeleteReceiverResponse deleteReceiver(DeleteReceiverRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/receivers/delete";
        DeleteReceiverRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeleteReceiverResponse.class);
        return (DeleteReceiverResponse)httpResponse.getServiceResponse();
    }

    public ReturnOrdersEntity createReturnOrder(CreateReturnOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/return-orders";
        CreateReturnOrderRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ReturnOrdersEntity.class);
        return (ReturnOrdersEntity)httpResponse.getServiceResponse();
    }

    public ReturnOrdersEntity queryReturnOrder(QueryReturnOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/return-orders/{out_return_no}";
        QueryReturnOrderRequest realRequest = request;
        requestPath = requestPath.replace("{out_return_no}", UrlEncoder.urlEncode((String)realRequest.getOutReturnNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getOutOrderNo() != null) {
            queryParameter.add("out_order_no", (Object)UrlEncoder.urlEncode((String)realRequest.getOutOrderNo()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ReturnOrdersEntity.class);
        return (ReturnOrdersEntity)httpResponse.getServiceResponse();
    }

    public QueryOrderAmountResponse queryOrderAmount(QueryOrderAmountRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/profitsharing/transactions/{transaction_id}/amounts";
        QueryOrderAmountRequest realRequest = request;
        requestPath = requestPath.replace("{transaction_id}", UrlEncoder.urlEncode((String)realRequest.getTransactionId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryOrderAmountResponse.class);
        return (QueryOrderAmountResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;
        private PrivacyEncryptor encryptor;
        private PrivacyDecryptor decryptor;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.encryptor = config.createEncryptor();
            this.decryptor = config.createDecryptor();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public Builder decryptor(PrivacyDecryptor decryptor) {
            this.decryptor = decryptor;
            return this;
        }

        public ProfitsharingService build() {
            return new ProfitsharingService(this.httpClient, this.hostName, this.encryptor, this.decryptor);
        }
    }
}

