// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付分停车服务
//
// 微信支付分停车服务 扣费API
//
// API version: 1.2.1

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.wexinpayscoreparking.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** CreateTransactionRequest */
public class CreateTransactionRequest {
  /** 公众账号id 说明：appid是商户在微信申请公众号或移动应用成功后分配的帐号ID，登录平台为mp.weixin.qq.com或open.weixin.qq.com */
  @SerializedName("appid")
  private String appid;
  /** 子公众账号id 说明：子公众账号id，服务商模式下选传，用于扣费信息的商户信息展示， */
  @SerializedName("sub_appid")
  private String subAppid;
  /** 子商户号 说明：微信支付分配的子商户号，服务商模式下必传 */
  @SerializedName("sub_mchid")
  private String subMchid;
  /** 服务描述 说明：商户自定义字段，用于交易账单中对扣费服务的描述。 */
  @SerializedName("description")
  private String description;
  /** 附加数据 说明：附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用 */
  @SerializedName("attach")
  private String attach;
  /** 商户订单号 说明：商户系统内部订单号，只能是数字、大小写字母_-*且在同一个商户号下唯一 */
  @SerializedName("out_trade_no")
  private String outTradeNo;
  /** 交易场景 说明：交易场景值，目前支持 ：PARKING：车场停车场景 */
  @SerializedName("trade_scene")
  private String tradeScene;
  /**
   * 订单优惠标记
   * 说明：代金券或立减优惠功能的参数，说明详见[代金券或立减优惠](https://pay.weixin.qq.com/wiki/doc/apiv3/open/pay/chapter5_1_2.shtml)
   */
  @SerializedName("goods_tag")
  private String goodsTag;
  /** 回调通知url 说明：接受扣款结果异步回调通知的url，注意回调url只接受https */
  @SerializedName("notify_url")
  private String notifyUrl;
  /**
   * 分账标识 说明：Y：是，需要分账 N：否，不分账
   * 字母要求大写，不传默认不分账，分账详细说明见[直连分账API](https://pay.weixin.qq.com/wiki/doc/api/allocation.php?chapter=26_1)、[服务商分账API文档](https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=24_1&index=1)
   */
  @SerializedName("profit_sharing")
  private String profitSharing;
  /** 订单金额 说明：订单金额信息 */
  @SerializedName("amount")
  private OrderAmount amount;
  /** 停车场景信息 说明：当交易场景为PARKING时，需要在该字段添加停车场景信息 */
  @SerializedName("parking_info")
  private ParkingTradeScene parkingInfo;

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getAttach() {
    return attach;
  }

  public void setAttach(String attach) {
    this.attach = attach;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getTradeScene() {
    return tradeScene;
  }

  public void setTradeScene(String tradeScene) {
    this.tradeScene = tradeScene;
  }

  public String getGoodsTag() {
    return goodsTag;
  }

  public void setGoodsTag(String goodsTag) {
    this.goodsTag = goodsTag;
  }

  public String getNotifyUrl() {
    return notifyUrl;
  }

  public void setNotifyUrl(String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  public String getProfitSharing() {
    return profitSharing;
  }

  public void setProfitSharing(String profitSharing) {
    this.profitSharing = profitSharing;
  }

  public OrderAmount getAmount() {
    return amount;
  }

  public void setAmount(OrderAmount amount) {
    this.amount = amount;
  }

  public ParkingTradeScene getParkingInfo() {
    return parkingInfo;
  }

  public void setParkingInfo(ParkingTradeScene parkingInfo) {
    this.parkingInfo = parkingInfo;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTransactionRequest {\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    attach: ").append(toIndentedString(attach)).append("\n");
    sb.append("    outTradeNo: ").append(toIndentedString(outTradeNo)).append("\n");
    sb.append("    tradeScene: ").append(toIndentedString(tradeScene)).append("\n");
    sb.append("    goodsTag: ").append(toIndentedString(goodsTag)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("    profitSharing: ").append(toIndentedString(profitSharing)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    parkingInfo: ").append(toIndentedString(parkingInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
