// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销商家券对外API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 0.0.11

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.merchantexclusivecoupon.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** SubsidyPayReceipt */
public class SubsidyPayReceipt {
  /** 补差付款单号 说明：补差付款唯一单号，由微信支付生成，仅在补差付款成功后有返回 */
  @SerializedName("subsidy_receipt_id")
  private String subsidyReceiptId;
  /** 商家券批次号 说明：由微信支付生成，调用创建商家券API成功时返回的唯一批次ID */
  @SerializedName("stock_id")
  private String stockId;
  /** 商家券code 说明：券的唯一标识 */
  @SerializedName("coupon_code")
  private String couponCode;
  /** 微信支付订单号 说明：微信支付下单支付成功返回的订单号 */
  @SerializedName("transaction_id")
  private String transactionId;
  /** 营销补差扣款商户号 说明：营销补差扣款商户号 */
  @SerializedName("payer_merchant")
  private String payerMerchant;
  /** 营销补差入账商户号 说明：营销补差入账商户号 */
  @SerializedName("payee_merchant")
  private String payeeMerchant;
  /**
   * 补差付款金额 说明：单位为分，单笔订单补差金额不得超过券的优惠金额，最高补差金额为5000元 > 券的优惠金额定义： 满减券：满减金额即为优惠金额 折扣券：优惠金额 = 微信支付订单金额 ÷
   * 折扣比例 × (1 - 折扣比例) 换购券：不支持
   */
  @SerializedName("amount")
  private Long amount;
  /** 补差付款描述 说明：付款备注描述，查询的时候原样带回 */
  @SerializedName("description")
  private String description;
  /** 补差付款单据状态 说明：补差付款单据状态 */
  @SerializedName("status")
  private SubsidyPayReceiptStatus status;
  /** 补差付款失败原因 说明：仅在补差付款失败时，返回告知对应失败的原因 */
  @SerializedName("fail_reason")
  private SubsidyPayReceiptFailReason failReason;
  /**
   * 补差付款完成时间
   * 说明：仅在补差付款成功时，返回完成时间。遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("success_time")
  private String successTime;
  /** 业务请求唯一单号 说明：商户侧需保证唯一性。可包含英文字母，数字，｜，_，*，-等内容，不允许出现其他不合法符号 */
  @SerializedName("out_subsidy_no")
  private String outSubsidyNo;
  /**
   * 补差付款发起时间
   * 说明：补差付款单据创建时间。遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("create_time")
  private String createTime;

  public String getSubsidyReceiptId() {
    return subsidyReceiptId;
  }

  public void setSubsidyReceiptId(String subsidyReceiptId) {
    this.subsidyReceiptId = subsidyReceiptId;
  }

  public String getStockId() {
    return stockId;
  }

  public void setStockId(String stockId) {
    this.stockId = stockId;
  }

  public String getCouponCode() {
    return couponCode;
  }

  public void setCouponCode(String couponCode) {
    this.couponCode = couponCode;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getPayerMerchant() {
    return payerMerchant;
  }

  public void setPayerMerchant(String payerMerchant) {
    this.payerMerchant = payerMerchant;
  }

  public String getPayeeMerchant() {
    return payeeMerchant;
  }

  public void setPayeeMerchant(String payeeMerchant) {
    this.payeeMerchant = payeeMerchant;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public SubsidyPayReceiptStatus getStatus() {
    return status;
  }

  public void setStatus(SubsidyPayReceiptStatus status) {
    this.status = status;
  }

  public SubsidyPayReceiptFailReason getFailReason() {
    return failReason;
  }

  public void setFailReason(SubsidyPayReceiptFailReason failReason) {
    this.failReason = failReason;
  }

  public String getSuccessTime() {
    return successTime;
  }

  public void setSuccessTime(String successTime) {
    this.successTime = successTime;
  }

  public String getOutSubsidyNo() {
    return outSubsidyNo;
  }

  public void setOutSubsidyNo(String outSubsidyNo) {
    this.outSubsidyNo = outSubsidyNo;
  }

  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubsidyPayReceipt {\n");
    sb.append("    subsidyReceiptId: ").append(toIndentedString(subsidyReceiptId)).append("\n");
    sb.append("    stockId: ").append(toIndentedString(stockId)).append("\n");
    sb.append("    couponCode: ").append(toIndentedString(couponCode)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    payerMerchant: ").append(toIndentedString(payerMerchant)).append("\n");
    sb.append("    payeeMerchant: ").append(toIndentedString(payeeMerchant)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    failReason: ").append(toIndentedString(failReason)).append("\n");
    sb.append("    successTime: ").append(toIndentedString(successTime)).append("\n");
    sb.append("    outSubsidyNo: ").append(toIndentedString(outSubsidyNo)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
