// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销商家券对外API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 0.0.11

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.merchantexclusivecoupon.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** FavorAvailableTime */
public class FavorAvailableTime {
  /**
   * 开始时间
   * 说明：批次开始时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。 注意：商家券有效期最长为1年。
   */
  @SerializedName("available_begin_time")
  private String availableBeginTime;
  /**
   * 结束时间
   * 说明：批次结束时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。 注意：商家券有效期最长为1年。
   */
  @SerializedName("available_end_time")
  private String availableEndTime;
  /**
   * 生效后N天内有效
   * 说明：日期区间内，券生效后x天内有效。例如生效当天内有效填1，生效后2天内有效填2，以此类推……注意，用户在有效期开始前领取商家券，则从有效期第1天开始计算天数，用户在有效期内领取商家券，则从领取当天开始计算天数，无论用户何时领取商家券，商家券在活动有效期结束后均不可用。可配合wait_days_after_receive一同填写，也可单独填写。单独填写时，有效期内领券后立即生效，生效后x天内有效。
   */
  @SerializedName("available_day_after_receive")
  private Integer availableDayAfterReceive;
  /** 固定周期有效时间段 说明：可以设置多个星期下的多个可用时间段，比如每周二10点到18点 */
  @SerializedName("available_week")
  private AvailableWeek availableWeek;
  /** 无规律的有效时间段 说明：无规律的有效时间，多个无规律时间段 */
  @SerializedName("irregulary_avaliable_time")
  private List<IrregularAvailableTime> irregularyAvaliableTime;
  /**
   * 领取后N天开始生效
   * 说明：日期区间内，用户领券后需等待x天开始生效。例如领券后当天开始生效则无需填写，领券后第2天开始生效填1，以此类推……用户在有效期开始前领取商家券，则从有效期第1天开始计算天数，用户在有效期内领取商家券，则从领取当天开始计算天数。无论用户何时领取商家券，商家券在活动有效期结束后均不可用。需配合available_day_after_receive一同填写，不可单独填写。注：最大不能超过30天
   */
  @SerializedName("wait_days_after_receive")
  private Integer waitDaysAfterReceive;

  public String getAvailableBeginTime() {
    return availableBeginTime;
  }

  public void setAvailableBeginTime(String availableBeginTime) {
    this.availableBeginTime = availableBeginTime;
  }

  public String getAvailableEndTime() {
    return availableEndTime;
  }

  public void setAvailableEndTime(String availableEndTime) {
    this.availableEndTime = availableEndTime;
  }

  public Integer getAvailableDayAfterReceive() {
    return availableDayAfterReceive;
  }

  public void setAvailableDayAfterReceive(Integer availableDayAfterReceive) {
    this.availableDayAfterReceive = availableDayAfterReceive;
  }

  public AvailableWeek getAvailableWeek() {
    return availableWeek;
  }

  public void setAvailableWeek(AvailableWeek availableWeek) {
    this.availableWeek = availableWeek;
  }

  public List<IrregularAvailableTime> getIrregularyAvaliableTime() {
    return irregularyAvaliableTime;
  }

  public void setIrregularyAvaliableTime(List<IrregularAvailableTime> irregularyAvaliableTime) {
    this.irregularyAvaliableTime = irregularyAvaliableTime;
  }

  public Integer getWaitDaysAfterReceive() {
    return waitDaysAfterReceive;
  }

  public void setWaitDaysAfterReceive(Integer waitDaysAfterReceive) {
    this.waitDaysAfterReceive = waitDaysAfterReceive;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FavorAvailableTime {\n");
    sb.append("    availableBeginTime: ").append(toIndentedString(availableBeginTime)).append("\n");
    sb.append("    availableEndTime: ").append(toIndentedString(availableEndTime)).append("\n");
    sb.append("    availableDayAfterReceive: ")
        .append(toIndentedString(availableDayAfterReceive))
        .append("\n");
    sb.append("    availableWeek: ").append(toIndentedString(availableWeek)).append("\n");
    sb.append("    irregularyAvaliableTime: ")
        .append(toIndentedString(irregularyAvaliableTime))
        .append("\n");
    sb.append("    waitDaysAfterReceive: ")
        .append(toIndentedString(waitDaysAfterReceive))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }
}
