// Copyright 2021 Tencent Inc. All rights reserved.
//
// 电商退款API
//
// 境内电商退款功能相关API文档
//
// API version: 1.1.8

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommercerefund.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** RefundReqAmount */
public class RefundReqAmount {
  /** 退款金额 说明：退款金额，币种的最小单位，只能为整数，不能超过原订单支付金额。 */
  @SerializedName("refund")
  private Long refund;
  /**
   * 退款出资账户及金额 说明：退款需要从指定账户出资时，传递此参数指定出资金额（币种的最小单位，只能为整数）。
   * 该功能优先级高于通过资金账户（funds_account）参数来指定可用余额出资退款功能，且二者不可同时使用。
   * 同时指定多个账户出资退款的使用场景需要满足以下条件：1、未开通退款支出分离产品功能；2、非电商平台垫付退款；3、订单属于分账订单，且分账处于待分账或分账中状态。
   * 参数传递需要满足条件：1、基本账户可用余额出资金额与基本账户不可用余额出资金额之和等于退款金额；2、账户类型不能重复。 上述任一条件不满足将返回错误
   */
  @SerializedName("from")
  private List<FundsFromItem> from;
  /** 原订单金额 说明：原支付交易的订单总金额，币种的最小单位，只能为整数 */
  @SerializedName("total")
  private Long total;
  /** 退款币种 说明：符合ISO 4217标准的三位字母代码，目前只支持人民币：CNY */
  @SerializedName("currency")
  private String currency;

  public Long getRefund() {
    return refund;
  }

  public void setRefund(Long refund) {
    this.refund = refund;
  }

  public List<FundsFromItem> getFrom() {
    return from;
  }

  public void setFrom(List<FundsFromItem> from) {
    this.from = from;
  }

  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundReqAmount {\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
