// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付电商平台分账API
//
// 微信支付电商平台分账API
//
// API version: 1.0.21

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommerceprofitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** OrderReceiverDetail */
public class OrderReceiverDetail {
  /** 分账接收商户号 说明：仅分账接收方类型为MERCHANT_ID时，填写微信支付分配的商户号 */
  @SerializedName("receiver_mchid")
  private String receiverMchid;
  /** 分账金额 说明：分账金额，单位为分，只能为整数，不能超过原订单支付金额及最大分账比例金额 */
  @SerializedName("amount")
  private Long amount;
  /** 分账描述 说明：分账的原因描述，分账账单中需要体现 */
  @SerializedName("description")
  private String description;
  /** 分账结果 说明：枚举值： 1. PENDING：待分账 2. SUCCESS：分账成功 3. CLOSED：已关闭 */
  @SerializedName("result")
  private String result;
  /** 分账完成时间 说明：分账完成时间，遵循RFC3339标准格式 */
  @SerializedName("finish_time")
  private String finishTime;
  /**
   * 分账失败原因 说明：分账失败原因。包含以下枚举值： 1. ACCOUNT\\_ABNORMAL : 分账接收账户异常 2. NO\\_RELATION : 分账关系已解除 3.
   * RECEIVER\\_HIGH\\_RISK : 高风险接收方 4. RECEIVER\\_REAL\\_NAME\\_NOT\\_VERIFIED : 接收方未实名 5.
   * NO\\_AUTH : 分账权限已解除 6. RECEIVER\\_RECEIPT\\_LIMIT : 超出用户月收款限额 7. PAYER\\_ACCOUNT\\_ABNORMAL :
   * 分出方账户异常 8. INVALID\\_REQUEST: 描述参数设置失败
   */
  @SerializedName("fail_reason")
  private String failReason;
  /**
   * 接收方类型 说明：接收方类型 枚举值： MERCHANT\\_ID：商户号（mch\\_id或者sub\\_mch\\_id）
   * PERSONAL\\_OPENID：个人OpenID（由服务商的APPID转换得到） PERSONAL\\_SUB\\_OPENID：个人SubOpenID（由品牌主的APPID转换得到）
   */
  @SerializedName("type")
  private String type;
  /**
   * 接收方账号 说明：接收方账号。 枚举值： 类型是MERCHANT\\_ID时，是商户号（mch\\_id或者sub\\_mch\\_id）
   * 类型是PERSONAL\\_OPENID时，是个人openid，[openid获取方法](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/open/pay/chapter3_3_1.shtml#part-13)
   */
  @SerializedName("receiver_account")
  private String receiverAccount;
  /** 分账明细单号 说明：微信分账明细单号，每笔分账业务执行的明细单号，可与资金账单对账使用 */
  @SerializedName("detail_id")
  private String detailId;

  public String getReceiverMchid() {
    return receiverMchid;
  }

  public void setReceiverMchid(String receiverMchid) {
    this.receiverMchid = receiverMchid;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public String getFinishTime() {
    return finishTime;
  }

  public void setFinishTime(String finishTime) {
    this.finishTime = finishTime;
  }

  public String getFailReason() {
    return failReason;
  }

  public void setFailReason(String failReason) {
    this.failReason = failReason;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getReceiverAccount() {
    return receiverAccount;
  }

  public void setReceiverAccount(String receiverAccount) {
    this.receiverAccount = receiverAccount;
  }

  public String getDetailId() {
    return detailId;
  }

  public void setDetailId(String detailId) {
    this.detailId = detailId;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderReceiverDetail {\n");
    sb.append("    receiverMchid: ").append(toIndentedString(receiverMchid)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    finishTime: ").append(toIndentedString(finishTime)).append("\n");
    sb.append("    failReason: ").append(toIndentedString(failReason)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    receiverAccount: ").append(toIndentedString(receiverAccount)).append("\n");
    sb.append("    detailId: ").append(toIndentedString(detailId)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
