// Copyright 2021 Tencent Inc. All rights reserved.
//
// 连锁加盟供应链分账API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 1.0.12

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.brandprofitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** ReceiverResultEntity */
public class ReceiverResultEntity {
  /**
   * 接收方类型 说明：枚举值： 1. MERCHANT_ID：商户ID 2. PERSONAL_OPENID：个人OpenID（由父商户AppID转换得到） 3.
   * PERSONAL_SUB_OPENID：个人OpenID（由品牌主的AppID转换得到）
   */
  @SerializedName("type")
  private String type;
  /**
   * 接收方账号 说明：1. 分账接收方类型为MERCHANT_ID时，分账接收方账号为商户号（mch_id或者sub_mch_id） 2.
   * 分账接收方类型为PERSONAL_OPENID时，分账接收方账号为个人OpenID（由服务商的AppID转换得到） 3.
   * 分账接收方类型为PERSONAL_SUB_OPENID时，分账接收方账号为个人OpenID（由品牌主的AppID转换得到）
   */
  @SerializedName("account")
  private String account;
  /** 分账金额 说明：分账金额，单位为分，只能为整数 */
  @SerializedName("amount")
  private Long amount;
  /** 分账描述 说明：分账的原因描述，分账账单中需要体现 */
  @SerializedName("description")
  private String description;
  /** 分账结果 说明：枚举值： - PENDING：待分账 - SUCCESS：分账成功 - CLOSED：已关闭 */
  @SerializedName("result")
  private String result;
  /**
   * 分账完成时间 说明：分账完成时间，遵循RFC3339标准格式，格式为
   * yyyy-MM-DDTHH:mm:ss.sss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss.sss表示时分秒毫秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35:120+08:00表示北京时间2015年05月20日13点29分35秒。
   */
  @SerializedName("finish_time")
  private String finishTime;
  /**
   * 分账失败原因 说明：分账失败原因。包含以下枚举值： 1. ACCOUNT_ABNORMAL : 分账接收账户异常 2. NO_RELATION : 分账关系已解除 3.
   * RECEIVER_HIGH_RISK : 高风险接收方 4. RECEIVER_REAL_NAME_NOT_VERIFIED : 接收方未实名 5. NO_AUTH : 分账权限已解除 6.
   * RECEIVER_RECEIPT_LIMIT : 超出用户月收款限额 7. PAYER_ACCOUNT_ABNORMAL : 分出方账户异常 8. INVALID_REQUEST :
   * 描述参数设置失败
   */
  @SerializedName("fail_reason")
  private String failReason;
  /** 分账明细单号 说明：微信分账明细单号，每笔分账业务执行的明细单号，可与资金账单对账使用 */
  @SerializedName("detail_id")
  private String detailId;

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public String getFinishTime() {
    return finishTime;
  }

  public void setFinishTime(String finishTime) {
    this.finishTime = finishTime;
  }

  public String getFailReason() {
    return failReason;
  }

  public void setFailReason(String failReason) {
    this.failReason = failReason;
  }

  public String getDetailId() {
    return detailId;
  }

  public void setDetailId(String detailId) {
    this.detailId = detailId;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiverResultEntity {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    finishTime: ").append(toIndentedString(finishTime)).append("\n");
    sb.append("    failReason: ").append(toIndentedString(failReason)).append("\n");
    sb.append("    detailId: ").append(toIndentedString(detailId)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
