// Copyright 2021 Tencent Inc. All rights reserved.
//
// 获取账单文件下载地址的对外API
//
// 为方便商户快速查询和核对账务信息，支持通过本接口获取离线账单的下载地址。
//
// API version: 2.1.4

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.billdownload.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.function.UnaryOperator;

/** EncryptBillEntity */
public class EncryptBillEntity {
  /** 账单文件序号 说明：账单文件序号，商户将多个文件按账单文件序号的顺序合并为完整的资金账单文件，起始值为1 */
  @SerializedName("bill_sequence")
  private Long billSequence;
  /** 哈希类型 说明：哈希类型 */
  @SerializedName("hash_type")
  private HashType hashType;
  /** 哈希值 说明：原始账单（gzip需要解压缩）的摘要值，用于校验文件的完整性。GCM算法加密的账单解密成功表示校验完整性通过。 */
  @SerializedName("hash_value")
  private String hashValue;
  /** 下载地址 说明：供下一步请求账单文件的下载地址，该地址5min内有效。 */
  @SerializedName("download_url")
  private String downloadUrl;
  /** 加密密钥 说明：加密账单文件使用的加密密钥。密钥用商户证书的公钥进行加密，然后进行Base64编码 */
  @Encryption
  @SerializedName("encrypt_key")
  private String encryptKey;
  /** 随机字符串 说明：加密账单文件使用的随机字符串 */
  @SerializedName("nonce")
  private String nonce;

  public Long getBillSequence() {
    return billSequence;
  }

  public void setBillSequence(Long billSequence) {
    this.billSequence = billSequence;
  }

  public HashType getHashType() {
    return hashType;
  }

  public void setHashType(HashType hashType) {
    this.hashType = hashType;
  }

  public String getHashValue() {
    return hashValue;
  }

  public void setHashValue(String hashValue) {
    this.hashValue = hashValue;
  }

  public String getDownloadUrl() {
    return downloadUrl;
  }

  public void setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
  }

  public String getEncryptKey() {
    return encryptKey;
  }

  public void setEncryptKey(String encryptKey) {
    this.encryptKey = encryptKey;
  }

  public String getNonce() {
    return nonce;
  }

  public void setNonce(String nonce) {
    this.nonce = nonce;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EncryptBillEntity {\n");
    sb.append("    billSequence: ").append(toIndentedString(billSequence)).append("\n");
    sb.append("    hashType: ").append(toIndentedString(hashType)).append("\n");
    sb.append("    hashValue: ").append(toIndentedString(hashValue)).append("\n");
    sb.append("    downloadUrl: ").append(toIndentedString(downloadUrl)).append("\n");
    sb.append("    encryptKey: ").append(toIndentedString(encryptKey)).append("\n");
    sb.append("    nonce: ").append(toIndentedString(nonce)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public EncryptBillEntity cloneWithCipher(UnaryOperator<String> s) {
    EncryptBillEntity copy = new EncryptBillEntity();
    copy.billSequence = billSequence;
    copy.hashType = hashType;
    copy.hashValue = hashValue;
    copy.downloadUrl = downloadUrl;
    if (encryptKey != null && !encryptKey.isEmpty()) {
      copy.encryptKey = s.apply(encryptKey);
    }
    copy.nonce = nonce;
    return copy;
  }
}
