/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultLazyPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.filter.DefaultLazyPropertyFilter;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultLazyPropertyResolver;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.lang.annotation.Annotation;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

@Configuration
public class EncryptablePropertyResolverConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EncryptablePropertyResolverConfiguration.class);
    private static final String ENCRYPTOR_BEAN_PLACEHOLDER = "${jasypt.encryptor.bean:jasyptStringEncryptor}";
    private static final String DETECTOR_BEAN_PLACEHOLDER = "${jasypt.encryptor.property.detector-bean:encryptablePropertyDetector}";
    private static final String RESOLVER_BEAN_PLACEHOLDER = "${jasypt.encryptor.property.resolver-bean:encryptablePropertyResolver}";
    private static final String FILTER_BEAN_PLACEHOLDER = "${jasypt.encryptor.property.filter-bean:encryptablePropertyFilter}";
    private static final String ENCRYPTOR_BEAN_NAME = "lazyJasyptStringEncryptor";
    private static final String DETECTOR_BEAN_NAME = "lazyEncryptablePropertyDetector";
    private static final String CONFIG_SINGLETON = "configPropsSingleton";
    static final String RESOLVER_BEAN_NAME = "lazyEncryptablePropertyResolver";
    static final String FILTER_BEAN_NAME = "lazyEncryptablePropertyFilter";

    @Bean
    public EnvCopy envCopy(ConfigurableEnvironment environment) {
        return new EnvCopy(environment);
    }

    @Bean(name={"lazyJasyptStringEncryptor"})
    public StringEncryptor stringEncryptor(EnvCopy envCopy, BeanFactory bf) {
        String customEncryptorBeanName = envCopy.get().resolveRequiredPlaceholders(ENCRYPTOR_BEAN_PLACEHOLDER);
        return new DefaultLazyEncryptor((Environment)envCopy.get(), customEncryptorBeanName, bf);
    }

    @Bean(name={"lazyEncryptablePropertyDetector"})
    public EncryptablePropertyDetector encryptablePropertyDetector(EnvCopy envCopy, BeanFactory bf) {
        String prefix = envCopy.get().resolveRequiredPlaceholders("${jasypt.encryptor.property.prefix:ENC(}");
        String suffix = envCopy.get().resolveRequiredPlaceholders("${jasypt.encryptor.property.suffix:)}");
        String customDetectorBeanName = envCopy.get().resolveRequiredPlaceholders(DETECTOR_BEAN_PLACEHOLDER);
        return new DefaultLazyPropertyDetector(prefix, suffix, customDetectorBeanName, bf);
    }

    @Bean(name={"configPropsSingleton"})
    public Singleton<JasyptEncryptorConfigurationProperties> configProps(EnvCopy envCopy, ConfigurableBeanFactory bf) {
        return new Singleton<JasyptEncryptorConfigurationProperties>(() -> {
            IgnoreErrorsBindHandler handler = new IgnoreErrorsBindHandler(BindHandler.DEFAULT);
            MutablePropertySources propertySources = envCopy.get().getPropertySources();
            Binder binder = new Binder(ConfigurationPropertySources.from((Iterable)propertySources), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Iterable)propertySources), ApplicationConversionService.getSharedInstance(), arg_0 -> ((ConfigurableBeanFactory)bf).copyRegisteredEditorsTo(arg_0));
            JasyptEncryptorConfigurationProperties config = new JasyptEncryptorConfigurationProperties();
            ResolvableType type = ResolvableType.forClass(JasyptEncryptorConfigurationProperties.class);
            Annotation annotation = AnnotationUtils.findAnnotation(JasyptEncryptorConfigurationProperties.class, ConfigurationProperties.class);
            Annotation[] annotations = new Annotation[]{annotation};
            Bindable target = Bindable.of((ResolvableType)type).withExistingValue((Object)config).withAnnotations(annotations);
            binder.bind("jasypt.encryptor", target, (BindHandler)handler);
            return config;
        });
    }

    @Bean(name={"lazyEncryptablePropertyFilter"})
    public EncryptablePropertyFilter encryptablePropertyFilter(EnvCopy envCopy, ConfigurableBeanFactory bf, @Qualifier(value="configPropsSingleton") Singleton<JasyptEncryptorConfigurationProperties> configProps) {
        String customFilterBeanName = envCopy.get().resolveRequiredPlaceholders(FILTER_BEAN_PLACEHOLDER);
        JasyptEncryptorConfigurationProperties.PropertyConfigurationProperties.FilterConfigurationProperties filterConfig = configProps.get().getProperty().getFilter();
        return new DefaultLazyPropertyFilter(filterConfig.getIncludeSources(), filterConfig.getExcludeSources(), filterConfig.getIncludeNames(), filterConfig.getExcludeNames(), customFilterBeanName, (BeanFactory)bf);
    }

    @Bean(name={"lazyEncryptablePropertyResolver"})
    public EncryptablePropertyResolver encryptablePropertyResolver(@Qualifier(value="lazyEncryptablePropertyDetector") EncryptablePropertyDetector propertyDetector, @Qualifier(value="lazyJasyptStringEncryptor") StringEncryptor encryptor, BeanFactory bf, EnvCopy envCopy) {
        String customResolverBeanName = envCopy.get().resolveRequiredPlaceholders(RESOLVER_BEAN_PLACEHOLDER);
        return new DefaultLazyPropertyResolver(propertyDetector, encryptor, customResolverBeanName, bf);
    }

    private static class EnvCopy {
        StandardEnvironment copy = new StandardEnvironment();

        EnvCopy(ConfigurableEnvironment environment) {
            environment.getPropertySources().forEach(ps -> {
                PropertySource original = ps instanceof EncryptablePropertySource ? ((EncryptablePropertySource)ps).getDelegate() : ps;
                this.copy.getPropertySources().addLast(original);
            });
        }

        ConfigurableEnvironment get() {
            return this.copy;
        }
    }
}

