/*
 * Decompiled with CFR 0.152.
 */
package com.zyh.ce4j.executor;

import com.zyh.ce4j.domain.ExecutedResult;
import com.zyh.ce4j.domain.Result;
import com.zyh.ce4j.executor.Executor;
import com.zyh.ce4j.strategy.CheckStrategy;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BaseExecutor
implements Executor {
    private boolean useStdoutStreamGobbler;
    private boolean collectAllOutputStdout;
    private CheckStrategy stdoutCes;
    private boolean useErrorStreamGobbler;
    private boolean collectAllOutputError;
    private CheckStrategy errorCes;
    private long timeout = 30L;
    private TimeUnit timeUnit = TimeUnit.MINUTES;

    private BaseExecutor(Builder builder) {
        this.useStdoutStreamGobbler = builder.useStdoutStreamGobbler;
        this.collectAllOutputStdout = builder.collectAllOutputStdout;
        this.stdoutCes = builder.stdoutCes;
        this.useErrorStreamGobbler = builder.useErrorStreamGobbler;
        this.collectAllOutputError = builder.collectAllOutputError;
        this.errorCes = builder.errorCes;
        this.timeout = builder.timeout;
        this.timeUnit = builder.timeUnit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void processOutputHandle(ExecutedResult result, Process pr, String comandLine, Executor.MutilComandsStream mcs) throws InterruptedException {
        Result res;
        Executor.StreamGobbler errorGobbler = null;
        if (this.useErrorStreamGobbler) {
            errorGobbler = mcs == null ? new Executor.StreamGobbler(pr.getErrorStream(), Executor.StreamGobblerType.ERROR, this.collectAllOutputError) : new Executor.StreamGobbler(pr.getErrorStream(), Executor.StreamGobblerType.ERROR, mcs, this.collectAllOutputError);
            errorGobbler.start();
        }
        Executor.StreamGobbler stdoutGobbler = null;
        if (this.useStdoutStreamGobbler) {
            stdoutGobbler = mcs == null ? new Executor.StreamGobbler(pr.getInputStream(), Executor.StreamGobblerType.STDOUT, this.collectAllOutputStdout) : new Executor.StreamGobbler(pr.getInputStream(), Executor.StreamGobblerType.STDOUT, mcs, this.collectAllOutputStdout);
            stdoutGobbler.start();
        }
        pr.waitFor(this.timeout, this.timeUnit);
        if (this.useErrorStreamGobbler) {
            res = errorGobbler.exeResult(this.errorCes);
            result.setStatus(res.getStatus());
            if (res.getStatus().equals((Object)Result.Status.FAILURE)) {
                res.setMsg(String.format("execute command line[%s] ,last print: %s, failed: %s", comandLine, stdoutGobbler.getLastPrint(), res.getMsg()));
            } else if (res.getStatus().equals((Object)Result.Status.UNKNOWN)) {
                res.setMsg(String.format("execute command line[%s] ,last print: %s", comandLine, stdoutGobbler.getLastPrint()));
            }
            result.setErrorResult(res);
        }
        if (this.useStdoutStreamGobbler) {
            res = stdoutGobbler.exeResult(this.stdoutCes);
            result.setStatus(res.getStatus());
            if (res.getStatus().equals((Object)Result.Status.FAILURE)) {
                res.setMsg(String.format("execute command line[%s] ,last print: %s, failed: %s", comandLine, stdoutGobbler.getLastPrint(), res.getMsg()));
            } else if (res.getStatus().equals((Object)Result.Status.UNKNOWN)) {
                res.setMsg(String.format("execute command line[%s] ,last print: %s", comandLine, stdoutGobbler.getLastPrint()));
            }
            result.setStdoutResult(res);
        }
    }

    @Override
    public ExecutedResult execute(String comandLine) {
        ExecutedResult result = new ExecutedResult();
        try {
            Process pr = Runtime.getRuntime().exec(comandLine);
            this.processOutputHandle(result, pr, comandLine, null);
        }
        catch (IOException | InterruptedException e) {
            result.setStatus(Result.Status.FAILURE);
            result.setErrorResult(new Result(Result.Status.FAILURE, String.format("execute command line[%s] failed: {%s}", comandLine, e.getMessage()), null));
        }
        return result;
    }

    @Override
    public ExecutedResult executeMutilShell(List<String> comandLine) {
        ExecutedResult result = new ExecutedResult();
        if (this.isWin()) {
            result.setStatus(Result.Status.REJECT);
            result.setErrorResult(new Result(Result.Status.REJECT, "\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u6267\u884cwin\u7684\u591a\u547d\u4ee4\u884c\uff0c\u63a8\u8350\u4f7f\u7528[execute(String comandLine)]", null));
            return result;
        }
        try {
            Process pr = Runtime.getRuntime().exec("/bin/bash", null, null);
            Executor.MutilComandsStream mcs = new Executor.MutilComandsStream(pr.getOutputStream(), comandLine);
            this.processOutputHandle(result, pr, String.join((CharSequence)"&&", comandLine), mcs);
        }
        catch (IOException | InterruptedException e) {
            result.setErrorResult(new Result(Result.Status.FAILURE, String.format("execute command line[%s] failed: {%s}", comandLine, e.getMessage()), null));
        }
        return result;
    }

    @Override
    public ExecutedResult execute(String[] cmdarray) {
        ExecutedResult result = new ExecutedResult();
        try {
            Process pr = Runtime.getRuntime().exec(cmdarray);
            this.processOutputHandle(result, pr, String.join((CharSequence)" ", cmdarray), null);
        }
        catch (IOException | InterruptedException e) {
            result.setStatus(Result.Status.FAILURE);
            result.setErrorResult(new Result(Result.Status.FAILURE, String.format("execute command line[%s] failed: {%s}", String.join((CharSequence)" ", cmdarray), e.getMessage()), null));
        }
        return result;
    }

    public static class Builder {
        private boolean useStdoutStreamGobbler = true;
        private boolean collectAllOutputStdout = false;
        private CheckStrategy stdoutCes = CheckStrategy.NONE_CHECK_STRATEGY_INSTANCE;
        private boolean useErrorStreamGobbler = false;
        private boolean collectAllOutputError = false;
        private CheckStrategy errorCes;
        private long timeout = 30L;
        private TimeUnit timeUnit = TimeUnit.MINUTES;

        public StdoutStreamGobblerBuilder useStdoutStreamGobbler(boolean useStdoutStreamGobbler, CheckStrategy stdoutCes) {
            this.useStdoutStreamGobbler = useStdoutStreamGobbler;
            this.stdoutCes = stdoutCes;
            return new StdoutStreamGobblerBuilder(this);
        }

        public ErrorStreamGobblerBuilder useErrorStreamGobbler(boolean useErrorStreamGobbler, CheckStrategy errorCes) {
            this.useErrorStreamGobbler = useErrorStreamGobbler;
            this.errorCes = errorCes;
            return new ErrorStreamGobblerBuilder(this);
        }

        public Builder setTimeout(Long timeout, TimeUnit timeUnit) {
            if (null != timeout) {
                this.timeout = timeout;
            }
            if (null != timeUnit) {
                this.timeUnit = timeUnit;
            }
            return this;
        }

        public BaseExecutor build() {
            return new BaseExecutor(this);
        }

        public class ErrorStreamGobblerBuilder {
            private Builder builder;

            public ErrorStreamGobblerBuilder(Builder builder) {
                this.builder = builder;
            }

            public Builder collectAllOutputError(boolean collectAllOutputError) {
                this.builder.collectAllOutputError = collectAllOutputError;
                return this.builder;
            }
        }

        public class StdoutStreamGobblerBuilder {
            private Builder builder;

            public StdoutStreamGobblerBuilder(Builder builder) {
                this.builder = builder;
            }

            public Builder collectAllOutputStdout(boolean collectAllOutputStdout) {
                this.builder.collectAllOutputStdout = collectAllOutputStdout;
                return this.builder;
            }
        }
    }
}

