/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import com.github.loki4j.common.LogRecord;
import com.github.loki4j.logback.AbstractLoki4jEncoder;
import com.github.loki4j.protobuf.Logproto;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import org.xerial.snappy.Snappy;

public class ProtobufEncoder
extends AbstractLoki4jEncoder {
    @Override
    public String getContentType() {
        return "application/x-protobuf";
    }

    @Override
    protected byte[] encodeStaticLabels(LogRecord[] batch) {
        Logproto.PushRequest.Builder request = Logproto.PushRequest.newBuilder();
        Logproto.StreamAdapter.Builder streamBuilder = request.addStreamsBuilder().setLabels(this.labels(this.extractStreamKVPairs(batch[0].stream)));
        for (int i = 0; i < batch.length; ++i) {
            streamBuilder.addEntries(this.entry(batch[i]));
        }
        return this.compress(request.build().toByteArray());
    }

    @Override
    protected byte[] encodeDynamicLabels(LogRecord[] batch) {
        Logproto.PushRequest.Builder request = Logproto.PushRequest.newBuilder();
        String currentStream = batch[0].stream;
        Logproto.StreamAdapter.Builder streamBuilder = request.addStreamsBuilder().setLabels(this.labels(this.extractStreamKVPairs(currentStream)));
        for (int i = 0; i < batch.length; ++i) {
            if (batch[i].stream != currentStream) {
                currentStream = batch[i].stream;
                streamBuilder = request.addStreamsBuilder().setLabels(this.labels(this.extractStreamKVPairs(currentStream)));
            }
            streamBuilder.addEntries(this.entry(batch[i]));
        }
        return this.compress(request.build().toByteArray());
    }

    private String labels(String[] labels) {
        StringBuilder s = new StringBuilder();
        s.append('{');
        if (labels.length > 0) {
            for (int i = 0; i < labels.length; i += 2) {
                s.append(labels[i]);
                s.append('=');
                s.append('\"');
                s.append(labels[i + 1].replace("\"", "\\\""));
                s.append('\"');
                if (i >= labels.length - 2) continue;
                s.append(',');
            }
        }
        s.append('}');
        return s.toString();
    }

    private Logproto.EntryAdapter entry(LogRecord record) {
        return Logproto.EntryAdapter.newBuilder().setTimestamp(Timestamp.newBuilder().setSeconds(record.timestampMs / 1000L).setNanos((int)(record.timestampMs % 1000L) * 1000000 + record.nanos)).setLine(record.message).build();
    }

    private byte[] compress(byte[] input) {
        try {
            return Snappy.compress((byte[])input);
        }
        catch (IOException e) {
            throw new RuntimeException("Snappy compression error", e);
        }
    }
}

