/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import com.github.loki4j.logback.AbstractLoki4jAppender;
import com.github.loki4j.logback.LokiThreadFactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LokiJavaHttpAppender
extends AbstractLoki4jAppender {
    private HttpClient client;
    private HttpRequest.Builder requestBuilder;
    private ExecutorService internalHttpThreadPool;

    @Override
    protected void startHttp(String contentType) {
        this.internalHttpThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, this.getBatchTimeoutMs() * 5L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new LokiThreadFactory("loki-java-http-internal"));
        this.client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(this.connectionTimeoutMs)).executor(this.internalHttpThreadPool).build();
        this.requestBuilder = HttpRequest.newBuilder().timeout(Duration.ofMillis(this.requestTimeoutMs)).uri(URI.create(this.url)).header("Content-Type", contentType);
    }

    @Override
    protected void stopHttp() {
        this.internalHttpThreadPool.shutdown();
    }

    @Override
    protected CompletableFuture<AbstractLoki4jAppender.LokiResponse> sendAsync(byte[] batch) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpRequest request = this.requestBuilder.copy().POST(HttpRequest.BodyPublishers.ofByteArray(batch)).build();
                HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
                return new AbstractLoki4jAppender.LokiResponse(response.statusCode(), response.body());
            }
            catch (Exception e) {
                throw new RuntimeException("Error while sending batch to Loki", e);
            }
        }, this.httpThreadPool);
    }
}

