/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import com.github.loki4j.logback.AbstractLoki4jAppender;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class LokiApacheHttpAppender
extends AbstractLoki4jAppender {
    private int maxConnections = 1;
    private long connectionTtlMs = 30000L;
    private CloseableHttpClient client;
    private Function<byte[], HttpPost> requestBuilder;

    @Override
    protected void startHttp(String contentType) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.connectionTtlMs, TimeUnit.MILLISECONDS);
        cm.setMaxTotal(this.maxConnections);
        cm.setDefaultMaxPerRoute(this.maxConnections);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout((int)this.connectionTimeoutMs).setConnectTimeout((int)this.connectionTimeoutMs).setConnectionRequestTimeout((int)this.requestTimeoutMs).build()).build();
        this.requestBuilder = body -> {
            HttpPost request = new HttpPost(this.url);
            request.addHeader("Content-Type", contentType);
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
            return request;
        };
    }

    @Override
    protected void stopHttp() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            this.addWarn("Error while closing Apache HttpClient", e);
        }
    }

    @Override
    protected CompletableFuture<AbstractLoki4jAppender.LokiResponse> sendAsync(byte[] batch) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                CloseableHttpResponse r = this.client.execute((HttpUriRequest)this.requestBuilder.apply(batch));
                HttpEntity entity = r.getEntity();
                return new AbstractLoki4jAppender.LokiResponse(r.getStatusLine().getStatusCode(), entity != null ? EntityUtils.toString((HttpEntity)entity) : "");
            }
            catch (Exception e) {
                throw new RuntimeException("Error while sending batch to Loki", e);
            }
        }, this.httpThreadPool);
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setConnectionTtlMs(long connectionTtlMs) {
        this.connectionTtlMs = connectionTtlMs;
    }
}

